/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfigAccessor;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name, boolean local) {
        Config config = this.nodeEngine.getConfig();
        MapConfig mapConfig = config.findMapConfig(name);
        SplitBrainMergePolicyProvider mergePolicyProvider = this.nodeEngine.getSplitBrainMergePolicyProvider();
        ConfigValidator.checkMapConfig(mapConfig, config.getNativeMemoryConfig(), mergePolicyProvider, this.mapServiceContext.getNodeEngine().getProperties());
        if (mapConfig.isNearCacheEnabled()) {
            NearCacheConfigAccessor.initDefaultMaxSizeForOnHeapMaps(mapConfig.getNearCacheConfig());
            ConfigValidator.checkNearCacheConfig(name, mapConfig.getNearCacheConfig(), config.getNativeMemoryConfig(), false);
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        this.mapServiceContext.destroyMap(name);
    }
}

