/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class PutBackupOperation
extends MapOperation
implements BackupOperation {
    protected Record<Data> record;
    protected Data dataKey;
    private Data dataValue;

    public PutBackupOperation(String name, Data dataKey, Record<Data> record, Data dataValue) {
        super(name);
        this.dataKey = dataKey;
        this.record = record;
        this.dataValue = dataValue;
    }

    public PutBackupOperation() {
    }

    @Override
    protected void runInternal() {
        Object currentRecord = this.recordStore.putBackup(this.dataKey, this.record, this.isPutTransient(), this.getCallerProvenance());
        Records.copyMetadataFrom(this.record, currentRecord);
    }

    protected boolean isPutTransient() {
        return false;
    }

    @Override
    protected void afterRunInternal() {
        this.evict(this.dataKey);
        this.publishWanUpdate(this.dataKey, this.record.getValue());
        super.afterRunInternal();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.dataKey);
        Records.writeRecord(out, this.record, this.dataValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dataKey = IOUtil.readData(in);
        this.record = Records.readRecord(in);
    }
}

