/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class RemoveBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private boolean disableWanReplicationEvent;

    public RemoveBackupOperation() {
    }

    public RemoveBackupOperation(String name, Data dataKey, boolean disableWanReplicationEvent) {
        super(name, dataKey);
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    @Override
    protected void runInternal() {
        this.recordStore.removeBackup(this.dataKey, this.getCallerProvenance());
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    protected void afterRunInternal() {
        this.publishWanRemove(this.dataKey);
        this.evict(this.dataKey);
        super.afterRunInternal();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.disableWanReplicationEvent = in.readBoolean();
    }
}

