/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class SetTtlBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private long ttl;

    public SetTtlBackupOperation() {
    }

    public SetTtlBackupOperation(String name, Data dataKey, long ttl) {
        super(name, dataKey);
        this.ttl = ttl;
    }

    @Override
    public int getClassId() {
        return 138;
    }

    @Override
    protected void runInternal() {
        this.recordStore.setTtl(this.dataKey, this.ttl, true);
    }

    @Override
    protected void afterRunInternal() {
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record != null) {
            this.publishWanUpdate(this.dataKey, record.getValue());
        }
        super.afterRunInternal();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ttl = in.readLong();
    }
}

