/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.SetTtlBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class SetTtlOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    private transient boolean response;
    private long ttl;

    public SetTtlOperation() {
    }

    public SetTtlOperation(String name, Data dataKey, long ttl) {
        super(name, dataKey);
        this.ttl = ttl;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    protected void runInternal() {
        this.response = this.recordStore.setTtl(this.dataKey, this.ttl, false);
    }

    @Override
    protected void afterRunInternal() {
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record != null) {
            this.publishWanUpdate(this.dataKey, record.getValue());
            this.invalidateNearCache(this.dataKey);
        }
        super.afterRunInternal();
    }

    @Override
    public int getClassId() {
        return 137;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new SetTtlBackupOperation(this.name, this.dataKey, this.ttl);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ttl = in.readLong();
    }
}

