/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntries;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;

public class WriteBehindStateHolder
implements IdentifiedDataSerializable {
    private MapReplicationOperation mapReplicationOperation;
    private Map<String, List<DelayedEntry>> delayedEntries;
    private Map<String, Queue<WriteBehindStore.Sequence>> flushSequences;
    private Map<String, Map<UUID, Long>> reservationsByTxnIdPerMap;

    public WriteBehindStateHolder() {
    }

    public WriteBehindStateHolder(MapReplicationOperation mapReplicationOperation) {
        this.mapReplicationOperation = mapReplicationOperation;
    }

    void prepare(PartitionContainer container, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        int size = namespaces.size();
        this.flushSequences = MapUtil.createHashMap(size);
        this.delayedEntries = MapUtil.createHashMap(size);
        this.reservationsByTxnIdPerMap = MapUtil.createHashMap(size);
        for (ServiceNamespace namespace : namespaces) {
            MapContainer mapContainer;
            MapConfig mapConfig;
            ObjectNamespace mapNamespace = (ObjectNamespace)namespace;
            String mapName = mapNamespace.getObjectName();
            RecordStore recordStore = container.getRecordStore(mapName);
            if (recordStore == null || (mapConfig = (mapContainer = recordStore.getMapContainer()).getMapConfig()).getTotalBackupCount() < replicaIndex || !mapContainer.getMapStoreContext().isWriteBehindMapStoreEnabled()) continue;
            WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
            this.reservationsByTxnIdPerMap.put(mapName, mapDataStore.getTxnReservedCapacityCounter().getReservedCapacityCountPerTxnId());
            WriteBehindQueue<DelayedEntry> writeBehindQueue = mapDataStore.getWriteBehindQueue();
            List<DelayedEntry> entries = writeBehindQueue.asList();
            if (entries == null || entries.isEmpty()) continue;
            this.delayedEntries.put(mapName, entries);
            this.flushSequences.put(mapName, new ArrayDeque<WriteBehindStore.Sequence>(mapDataStore.getFlushSequences()));
        }
    }

    void applyState() {
        String mapName;
        for (Map.Entry<String, Map<UUID, Long>> entry : this.reservationsByTxnIdPerMap.entrySet()) {
            mapName = entry.getKey();
            Map<UUID, Long> reservationsByTxnId = entry.getValue();
            RecordStore recordStore = this.mapReplicationOperation.getRecordStore(mapName);
            WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
            mapDataStore.getTxnReservedCapacityCounter().putAll(reservationsByTxnId);
        }
        for (Map.Entry<String, Object> entry : this.delayedEntries.entrySet()) {
            mapName = entry.getKey();
            RecordStore recordStore = this.mapReplicationOperation.getRecordStore(mapName);
            WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
            mapDataStore.reset();
            mapDataStore.setFlushSequences(this.flushSequences.get(mapName));
            Collection replicatedEntries = (Collection)entry.getValue();
            for (DelayedEntry delayedEntry : replicatedEntries) {
                mapDataStore.addForcibly(delayedEntry);
                mapDataStore.setSequence(delayedEntry.getSequence());
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        MapService mapService = (MapService)this.mapReplicationOperation.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        out.writeInt(this.delayedEntries.size());
        for (Map.Entry<String, List<DelayedEntry>> entry : this.delayedEntries.entrySet()) {
            out.writeUTF(entry.getKey());
            List<DelayedEntry> delayedEntryList = entry.getValue();
            out.writeInt(delayedEntryList.size());
            for (DelayedEntry delayedEntry : delayedEntryList) {
                Data key = mapServiceContext.toData(delayedEntry.getKey());
                Data value = mapServiceContext.toData(delayedEntry.getValue());
                long expirationTime = delayedEntry.getExpirationTime();
                IOUtil.writeData(out, key);
                IOUtil.writeData(out, value);
                out.writeLong(expirationTime);
                out.writeLong(delayedEntry.getStoreTime());
                out.writeInt(delayedEntry.getPartitionId());
                out.writeLong(delayedEntry.getSequence());
                UUIDSerializationUtil.writeUUID(out, delayedEntry.getTxnId());
            }
        }
        out.writeInt(this.flushSequences.size());
        for (Map.Entry<String, Collection<Object>> entry : this.flushSequences.entrySet()) {
            out.writeUTF(entry.getKey());
            Queue queue = (Queue)entry.getValue();
            out.writeInt(queue.size());
            for (WriteBehindStore.Sequence sequence : queue) {
                out.writeLong(sequence.getSequence());
                out.writeBoolean(sequence.isFullFlush());
            }
        }
        out.writeInt(this.reservationsByTxnIdPerMap.size());
        for (Map.Entry<String, Object> entry : this.reservationsByTxnIdPerMap.entrySet()) {
            out.writeUTF(entry.getKey());
            Map reservationsByTxnId = (Map)entry.getValue();
            out.writeInt(reservationsByTxnId.size());
            for (Map.Entry entry2 : reservationsByTxnId.entrySet()) {
                UUIDSerializationUtil.writeUUID(out, (UUID)entry2.getKey());
                out.writeLong((Long)entry2.getValue());
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.delayedEntries = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            String mapName = in.readUTF();
            int listSize = in.readInt();
            ArrayList<DelayedEntry<Data, Data>> delayedEntriesList = new ArrayList<DelayedEntry<Data, Data>>(listSize);
            for (int j = 0; j < listSize; ++j) {
                Data key = IOUtil.readData(in);
                Data value = IOUtil.readData(in);
                long expirationTime = in.readLong();
                long storeTime = in.readLong();
                int partitionId = in.readInt();
                long sequence = in.readLong();
                UUID txnId = UUIDSerializationUtil.readUUID(in);
                DelayedEntry<Data, Data> entry = DelayedEntries.newAddedDelayedEntry(key, value, expirationTime, storeTime, partitionId, txnId);
                entry.setSequence(sequence);
                delayedEntriesList.add(entry);
            }
            this.delayedEntries.put(mapName, delayedEntriesList);
        }
        int expectedSize = in.readInt();
        this.flushSequences = MapUtil.createHashMap(expectedSize);
        for (int i = 0; i < expectedSize; ++i) {
            String mapName = in.readUTF();
            int setSize = in.readInt();
            ArrayDeque<WriteBehindStore.Sequence> queue = new ArrayDeque<WriteBehindStore.Sequence>(setSize);
            for (int j = 0; j < setSize; ++j) {
                queue.add(new WriteBehindStore.Sequence(in.readLong(), in.readBoolean()));
            }
            this.flushSequences.put(mapName, queue);
        }
        int mapCount = in.readInt();
        this.reservationsByTxnIdPerMap = mapCount == 0 ? Collections.emptyMap() : new HashMap(mapCount);
        for (int i = 0; i < mapCount; ++i) {
            String mapName = in.readUTF();
            int numOfCounters = in.readInt();
            Map<UUID, Long> counterByTxnId = MapUtil.createHashMap(numOfCounters);
            for (int j = 0; j < numOfCounters; ++j) {
                counterByTxnId.put(UUIDSerializationUtil.readUUID(in), in.readLong());
            }
            this.reservationsByTxnIdPerMap.put(mapName, counterByTxnId);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 104;
    }
}

