/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EventJournalMapEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.iterator.MapPartitionIterator;
import com.hazelcast.map.impl.iterator.MapQueryPartitionIterator;
import com.hazelcast.map.impl.journal.MapEventJournalReadOperation;
import com.hazelcast.map.impl.journal.MapEventJournalSubscribeOperation;
import com.hazelcast.map.impl.proxy.MapProxySupport;
import com.hazelcast.map.impl.query.AggregationResult;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultUtils;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndProvider;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapProxyImpl<K, V>
extends MapProxySupport<K, V>
implements EventJournalReader<EventJournalMapEvent<K, V>> {
    public MapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine, MapConfig mapConfig) {
        super(name, mapService, nodeEngine, mapConfig);
    }

    @Override
    public V get(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return (V)this.toObject(this.getInternal(key));
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        Data result = this.putInternal(key, valueData, ttl, timeunit, -1L, TimeUnit.MILLISECONDS);
        return (V)this.toObject(result);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        Data result = this.putInternal(key, valueData, ttl, ttlUnit, maxIdle, maxIdleUnit);
        return (V)this.toObject(result);
    }

    @Override
    public boolean tryPut(@Nonnull K key, @Nonnull V value, long timeout, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        return this.tryPutInternal(key, valueData, timeout, timeunit);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        Data result = this.putIfAbsentInternal(key, valueData, ttl, timeunit, -1L, TimeUnit.MILLISECONDS);
        return (V)this.toObject(result);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        Data result = this.putIfAbsentInternal(key, valueData, ttl, timeunit, maxIdle, maxIdleUnit);
        return (V)this.toObject(result);
    }

    @Override
    public void putTransient(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        this.putTransientInternal(key, valueData, ttl, timeunit, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void putTransient(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        this.putTransientInternal(key, valueData, ttl, ttlUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(oldValue, "Null value is not allowed!");
        Preconditions.checkNotNull(newValue, "Null value is not allowed!");
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        return this.replaceInternal(key, oldValueData, newValueData);
    }

    @Override
    public V replace(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Data valueData = this.toData(value);
        return (V)this.toObject(this.replaceInternal(key, valueData));
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Data valueData = this.toData(value);
        this.setInternal(key, valueData, ttl, ttlUnit, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        this.setInternal(key, valueData, ttl, ttlUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public V remove(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data result = this.removeInternal(key);
        return (V)this.toObject(result);
    }

    @Override
    public boolean remove(@Nonnull Object key, @Nonnull Object value) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Data valueData = this.toData(value);
        return this.removeInternal(key, valueData);
    }

    @Override
    public void removeAll(@Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        this.handleHazelcastInstanceAwareParams(predicate);
        this.removeAllInternal(predicate);
    }

    @Override
    public void delete(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        this.deleteInternal(key);
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Data valueData = this.toData(value);
        return this.containsValueInternal(valueData);
    }

    @Override
    public void lock(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        this.lockSupport.lock(this.getNodeEngine(), keyData);
    }

    @Override
    public void lock(@Nonnull Object key, long leaseTime, @Nullable TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkPositive(leaseTime, "leaseTime should be positive");
        Data keyData = this.toDataWithStrategy(key);
        this.lockSupport.lock(this.getNodeEngine(), keyData, TimeUtil.timeInMsOrTimeIfNullUnit(leaseTime, timeUnit));
    }

    @Override
    public void unlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        this.lockSupport.unlock(this.getNodeEngine(), keyData);
    }

    @Override
    public boolean tryRemove(@Nonnull K key, long timeout, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        return this.tryRemoveInternal(key, timeout, timeunit);
    }

    @Override
    public InternalCompletableFuture<V> getAsync(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.getAsyncInternal(key));
    }

    @Override
    public boolean isLocked(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        return this.lockSupport.isLocked(this.getNodeEngine(), keyData);
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value) {
        return this.putAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.putAsyncInternal(key, valueData, ttl, timeunit, -1L, TimeUnit.MILLISECONDS));
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.putAsyncInternal(key, valueData, ttl, ttlUnit, maxIdle, maxIdleUnit));
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value) {
        return this.setAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        Data valueData = this.toData(value);
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.setAsyncInternal(key, valueData, ttl, timeunit, -1L, TimeUnit.MILLISECONDS));
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(value, "Null value is not allowed!");
        Preconditions.checkNotNull(ttlUnit, "Null ttlUnit is not allowed!");
        Preconditions.checkNotNull(maxIdleUnit, "Null maxIdleUnit is not allowed!");
        Data valueData = this.toData(value);
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.setAsyncInternal(key, valueData, ttl, ttlUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public InternalCompletableFuture<V> removeAsync(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, this.removeAsyncInternal(key));
    }

    @Override
    public Map<K, V> getAll(@Nullable Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        int keysSize = keys.size();
        LinkedList<Data> dataKeys = new LinkedList<Data>();
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keysSize * 2);
        this.getAllInternal(keys, dataKeys, resultingKeyValuePairs);
        Map result = MapUtil.createHashMap(keysSize);
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean setTtl(@Nonnull K key, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Preconditions.checkNotNull(timeunit, "Null timeunit is not allowed!");
        return this.setTtlInternal(key, ttl, timeunit);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
        Preconditions.checkNotNull(map, "Null argument map is not allowed");
        this.putAllInternal(map, null);
    }

    public InternalCompletableFuture<Void> putAllAsync(@Nonnull Map<? extends K, ? extends V> map) {
        Preconditions.checkNotNull(map, "Null argument map is not allowed");
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        this.putAllInternal(map, future);
        return future;
    }

    @Override
    public boolean tryLock(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        return this.lockSupport.tryLock(this.getNodeEngine(), keyData);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        return this.lockSupport.tryLock(this.getNodeEngine(), keyData, time, timeunit);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit, long leaseTime, @Nullable TimeUnit leaseTimeUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        return this.lockSupport.tryLock(this.getNodeEngine(), keyData, time, timeunit, leaseTime, leaseTimeUnit);
    }

    @Override
    public void forceUnlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Data keyData = this.toDataWithStrategy(key);
        this.lockSupport.forceUnlock(this.getNodeEngine(), keyData);
    }

    @Override
    public String addInterceptor(@Nonnull MapInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor, "Interceptor should not be null!");
        this.handleHazelcastInstanceAwareParams(interceptor);
        return this.addMapInterceptorInternal(interceptor);
    }

    @Override
    public boolean removeInterceptor(@Nonnull String id) {
        Preconditions.checkNotNull(id, "Interceptor ID should not be null!");
        return this.removeMapInterceptorInternal(id);
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        this.handleHazelcastInstanceAwareParams(listener);
        return this.addLocalEntryListenerInternal(listener);
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        this.handleHazelcastInstanceAwareParams(listener, predicate);
        return this.addLocalEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, @Nullable K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        this.handleHazelcastInstanceAwareParams(listener, predicate);
        return this.addLocalEntryListenerInternal(listener, predicate, this.toDataWithStrategy(key), includeValue);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        this.handleHazelcastInstanceAwareParams(listener);
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        this.handleHazelcastInstanceAwareParams(listener);
        return this.addEntryListenerInternal(listener, this.toDataWithStrategy(key), includeValue);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, @Nullable K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        this.handleHazelcastInstanceAwareParams(listener, predicate);
        return this.addEntryListenerInternal(listener, predicate, this.toDataWithStrategy(key), includeValue);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        this.handleHazelcastInstanceAwareParams(listener, predicate);
        return this.addEntryListenerInternal(listener, predicate, null, includeValue);
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID id) {
        Preconditions.checkNotNull(id, "Listener ID should not be null!");
        return this.removeEntryListenerInternal(id);
    }

    @Override
    public UUID addPartitionLostListener(@Nonnull MapPartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        this.handleHazelcastInstanceAwareParams(listener);
        return this.addPartitionLostListenerInternal(listener);
    }

    @Override
    public boolean removePartitionLostListener(@Nonnull UUID id) {
        Preconditions.checkNotNull(id, "Listener ID should not be null!");
        return this.removePartitionLostListenerInternal(id);
    }

    @Override
    public EntryView<K, V> getEntryView(@Nonnull K key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        SimpleEntryView entryViewInternal = (SimpleEntryView)this.getEntryViewInternal(this.toDataWithStrategy(key));
        if (entryViewInternal == null) {
            return null;
        }
        Data value = (Data)entryViewInternal.getValue();
        entryViewInternal.setKey(key);
        entryViewInternal.setValue(this.toObject(value));
        return entryViewInternal;
    }

    @Override
    public boolean evict(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        return this.evictInternal(key);
    }

    @Override
    public void evictAll() {
        this.evictAllInternal();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        Preconditions.checkTrue(this.isMapStoreEnabled(), "First you should configure a map store");
        this.loadAllInternal(replaceExistingValues);
    }

    @Override
    public void loadAll(@Nonnull Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, "Null keys collection is not allowed!");
        Preconditions.checkNoNullInside(keys, "Null key is not allowed!");
        Preconditions.checkTrue(this.isMapStoreEnabled(), "First you should configure a map store");
        this.loadInternal(keys, null, replaceExistingValues);
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.keySet(Predicates.alwaysTrue());
    }

    @Override
    public Set<K> keySet(@Nonnull Predicate<K, V> predicate) {
        return this.executePredicate(predicate, IterationType.KEY, true);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(Predicates.alwaysTrue());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(@Nonnull Predicate predicate) {
        return this.executePredicate(predicate, IterationType.ENTRY, true);
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.values(Predicates.alwaysTrue());
    }

    @Override
    public Collection<V> values(@Nonnull Predicate predicate) {
        return this.executePredicate(predicate, IterationType.VALUE, false);
    }

    private Set executePredicate(Predicate predicate, IterationType iterationType, boolean uniqueResult) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        QueryResult result = (QueryResult)this.executeQueryInternal(predicate, iterationType, Target.ALL_NODES);
        this.incrementOtherOperationsStat();
        return QueryResultUtils.transformToSet(this.serializationService, result, predicate, iterationType, uniqueResult, false);
    }

    @Override
    public Set<K> localKeySet() {
        return this.localKeySet(Predicates.alwaysTrue());
    }

    @Override
    public Set<K> localKeySet(@Nonnull Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        QueryResult result = (QueryResult)this.executeQueryInternal(predicate, IterationType.KEY, Target.LOCAL_NODE);
        this.incrementOtherOperationsStat();
        return QueryResultUtils.transformToSet(this.serializationService, result, predicate, IterationType.KEY, false, false);
    }

    @Override
    public <R> R executeOnKey(@Nonnull K key, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        this.handleHazelcastInstanceAwareParams(entryProcessor);
        Data result = this.executeOnKeyInternal(key, entryProcessor);
        return (R)this.toObject(result);
    }

    @Override
    public <R> Map<K, R> executeOnKeys(@Nonnull Set<K> keys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        try {
            return (Map)this.submitToKeys(keys, entryProcessor).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public <R> InternalCompletableFuture<Map<K, R>> submitToKeys(@Nonnull Set<K> keys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(keys, "Null keys collection is not allowed!");
        if (keys.isEmpty()) {
            return InternalCompletableFuture.newCompletedFuture(Collections.emptyMap());
        }
        this.handleHazelcastInstanceAwareParams(entryProcessor);
        Set dataKeys = SetUtil.createHashSet(keys.size());
        return this.submitToKeysInternal((Set)keys, dataKeys, (EntryProcessor)entryProcessor);
    }

    @Override
    public <R> void submitToKey(@Nonnull K key, @Nonnull EntryProcessor<K, V, R> entryProcessor, ExecutionCallback<? super R> callback) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        this.handleHazelcastInstanceAwareParams(entryProcessor, callback);
        this.executeOnKeyInternal((Object)key, (EntryProcessor)entryProcessor, (ExecutionCallback)callback);
    }

    @Override
    public <R> InternalCompletableFuture<R> submitToKey(@Nonnull K key, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        this.handleHazelcastInstanceAwareParams(entryProcessor);
        InternalCompletableFuture future = this.executeOnKeyInternal((Object)key, (EntryProcessor)entryProcessor, (ExecutionCallback)null);
        return InternalCompletableFuture.newDelegatingFuture(this.serializationService, future);
    }

    @Override
    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> entryProcessor) {
        return this.executeOnEntries(entryProcessor, Predicates.alwaysTrue());
    }

    @Override
    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> entryProcessor, @Nonnull Predicate<K, V> predicate) {
        this.handleHazelcastInstanceAwareParams(entryProcessor, predicate);
        ArrayList result = new ArrayList();
        this.executeOnEntriesInternal((EntryProcessor)entryProcessor, (Predicate)predicate, (List)result);
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        Map resultingMap = MapUtil.createHashMap(result.size() / 2);
        int i = 0;
        while (i < result.size()) {
            Data key = (Data)result.get(i++);
            Data value = (Data)result.get(i++);
            resultingMap.put(this.toObject(key), this.toObject(value));
        }
        return resultingMap;
    }

    @Override
    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> aggregator) {
        return this.aggregate(aggregator, Predicates.alwaysTrue());
    }

    @Override
    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> aggregator, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(aggregator, "Aggregator should not be null!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapProxyImpl.checkNotPagingPredicate(predicate, "aggregate");
        aggregator = (Aggregator)this.serializationService.toObject(this.serializationService.toData(aggregator));
        AggregationResult result = (AggregationResult)this.executeQueryInternal(predicate, aggregator, null, IterationType.ENTRY, Target.ALL_NODES);
        return result.getAggregator().aggregate();
    }

    @Override
    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> projection) {
        return this.project(projection, Predicates.alwaysTrue());
    }

    @Override
    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> projection, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(projection, "Projection should not be null!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        MapProxyImpl.checkNotPagingPredicate(predicate, "project");
        projection = (Projection)this.serializationService.toObject(this.serializationService.toData(projection));
        QueryResult result = (QueryResult)this.executeQueryInternal(predicate, null, projection, IterationType.VALUE, Target.ALL_NODES);
        return QueryResultUtils.transformToSet(this.serializationService, result, predicate, IterationType.VALUE, false, false);
    }

    protected Object invoke(Operation operation, int partitionId) throws Throwable {
        InvocationFuture future = this.operationService.invokeOnPartition("hz:impl:mapService", operation, partitionId);
        Object response = future.get();
        Object result = this.toObject(response);
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        return result;
    }

    public Iterator<Map.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        return new MapPartitionIterator(this, fetchSize, partitionId, prefetchValues);
    }

    public <R> Iterator<R> iterator(int fetchSize, int partitionId, Projection<? super Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Paging predicate is not allowed when iterating map by query");
        }
        Preconditions.checkNotNull(projection, "Projection should not be null!");
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        projection = (Projection)this.serializationService.toObject(this.serializationService.toData(projection));
        this.handleHazelcastInstanceAwareParams(predicate);
        return new MapQueryPartitionIterator(this, fetchSize, partitionId, predicate, projection);
    }

    @Override
    public CompletionStage<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        MapEventJournalSubscribeOperation op = new MapEventJournalSubscribeOperation(this.name);
        op.setPartitionId(partitionId);
        return this.operationService.invokeOnPartition(op);
    }

    @Override
    public <T> CompletionStage<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, java.util.function.Predicate<? super EventJournalMapEvent<K, V>> predicate, Function<? super EventJournalMapEvent<K, V>, ? extends T> projection) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be greater or equal to minSize " + minSize);
        }
        ManagedContext context = this.serializationService.getManagedContext();
        context.initialize(predicate);
        context.initialize(projection);
        MapEventJournalReadOperation op = new MapEventJournalReadOperation(this.name, startSequence, minSize, maxSize, predicate, projection);
        op.setPartitionId(partitionId);
        return this.operationService.invokeOnPartition(op);
    }

    @Override
    public String toString() {
        return "IMap{name='" + this.name + '\'' + '}';
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name) {
        Preconditions.checkNotNull(name, "name cannot be null");
        return this.getQueryCacheInternal(name, null, null, null, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        this.handleHazelcastInstanceAwareParams(predicate);
        return this.getQueryCacheInternal(name, null, predicate, includeValue, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name, @Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        this.handleHazelcastInstanceAwareParams(listener, predicate);
        return this.getQueryCacheInternal(name, listener, predicate, includeValue, this);
    }

    private QueryCache<K, V> getQueryCacheInternal(@Nonnull String name, @Nullable MapListener listener, @Nullable Predicate<K, V> predicate, @Nullable Boolean includeValue, @Nonnull IMap<K, V> map) {
        QueryCacheContext queryCacheContext = this.mapServiceContext.getQueryCacheContext();
        QueryCacheRequest request = QueryCacheRequest.newQueryCacheRequest().forMap(map).withCacheName(name).withListener(listener).withPredicate(predicate).withIncludeValue(includeValue).withContext(queryCacheContext);
        return this.createQueryCache(request);
    }

    private QueryCache<K, V> createQueryCache(QueryCacheRequest request) {
        QueryCacheContext queryCacheContext = request.getContext();
        SubscriberContext subscriberContext = queryCacheContext.getSubscriberContext();
        QueryCacheEndToEndProvider queryCacheEndToEndProvider = subscriberContext.getEndToEndQueryCacheProvider();
        return queryCacheEndToEndProvider.getOrCreateQueryCache(request.getMapName(), request.getCacheName(), subscriberContext.newEndToEndConstructor(request));
    }

    private static void checkNotPagingPredicate(Predicate predicate, String method) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("PagingPredicate not supported in " + method + " method");
        }
    }
}

