/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.map.EntryLoader;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.recordstore.BasicRecordStoreLoader;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class EntryRecordStoreLoader
extends BasicRecordStoreLoader {
    EntryRecordStoreLoader(RecordStore recordStore) {
        super(recordStore);
    }

    @Override
    protected List<Data> getLoadingSequence(Map<?, ?> entries) {
        ArrayList<Data> keyValueSequence = new ArrayList<Data>(entries.size() * 2);
        for (Map.Entry<?, ?> entry : entries.entrySet()) {
            Object key = entry.getKey();
            EntryLoader.MetadataAwareValue loaderEntry = (EntryLoader.MetadataAwareValue)entry.getValue();
            Object value = loaderEntry.getValue();
            long expirationTime = loaderEntry.getExpirationTime();
            Data dataKey = this.mapServiceContext.toData(key);
            Data dataValue = this.mapServiceContext.toData(value);
            Data dataExpirationTime = this.mapServiceContext.toData(expirationTime);
            keyValueSequence.add(dataKey);
            keyValueSequence.add(dataValue);
            keyValueSequence.add(dataExpirationTime);
        }
        return keyValueSequence;
    }

    @Override
    protected Operation createOperation(List<Data> loadingSequence) {
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(this.name);
        return operationProvider.createPutFromLoadAllOperation(this.name, loadingSequence, true);
    }
}

