/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.OrderedIndexStore;
import com.hazelcast.query.impl.UnorderedIndexStore;
import com.hazelcast.query.impl.getters.Extractors;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IndexImpl
extends AbstractIndex {
    private final Set<Integer> indexedPartitions = Collections.newSetFromMap(new ConcurrentHashMap());

    public IndexImpl(IndexConfig config, InternalSerializationService ss, Extractors extractors, IndexCopyBehavior copyBehavior, PerIndexStats stats) {
        super(config, ss, extractors, copyBehavior, stats, null);
    }

    @Override
    protected IndexStore createIndexStore(boolean ordered, PerIndexStats stats) {
        return ordered ? new OrderedIndexStore(this.copyBehavior) : new UnorderedIndexStore(this.copyBehavior);
    }

    @Override
    public void clear() {
        super.clear();
        this.indexedPartitions.clear();
    }

    @Override
    public boolean hasPartitionIndexed(int partitionId) {
        return this.indexedPartitions.contains(partitionId);
    }

    @Override
    public void markPartitionAsIndexed(int partitionId) {
        assert (!this.indexedPartitions.contains(partitionId));
        this.indexedPartitions.add(partitionId);
    }

    @Override
    public void markPartitionAsUnindexed(int partitionId) {
        this.indexedPartitions.remove(partitionId);
    }
}

