/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa.operations;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAService;
import com.hazelcast.transaction.impl.xa.operations.AbstractXAOperation;
import java.io.IOException;

public class ClearRemoteTransactionBackupOperation
extends AbstractXAOperation
implements BackupOperation {
    private Data xidData;
    private transient SerializableXID xid;

    public ClearRemoteTransactionBackupOperation() {
    }

    public ClearRemoteTransactionBackupOperation(Data xidData) {
        this.xidData = xidData;
    }

    @Override
    public void beforeRun() throws Exception {
        this.xid = (SerializableXID)this.getNodeEngine().toObject(this.xidData);
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        xaService.removeTransactions(this.xid);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.xidData);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.xidData = IOUtil.readData(in);
    }

    @Override
    public int getClassId() {
        return 9;
    }
}

