/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.wan.MigrationAwareWanReplicationPublisher;
import com.hazelcast.wan.WanReplicationEvent;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.impl.InternalWanReplicationPublisher;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class DelegatingWanReplicationScheme {
    private final String name;
    private final ConcurrentMap<String, WanReplicationPublisher> publishers;

    public DelegatingWanReplicationScheme(@Nonnull String name, @Nonnull ConcurrentMap<String, WanReplicationPublisher> publishers) {
        Preconditions.checkNotNull(name, "WAN publisher name should not be null");
        Preconditions.checkNotNull(publishers, "WAN publisher map should not be null");
        this.name = name;
        this.publishers = publishers;
    }

    @Nonnull
    public Collection<WanReplicationPublisher> getPublishers() {
        return this.publishers.values();
    }

    public WanReplicationPublisher getPublisher(String publisherId) {
        return (WanReplicationPublisher)this.publishers.get(publisherId);
    }

    public void addPublisher(@Nonnull String publisherId, @Nonnull WanReplicationPublisher publisher) {
        if (this.publishers.putIfAbsent(publisherId, publisher) != null) {
            throw new IllegalStateException("Publisher with publisher ID " + publisherId + " on WAN replication scheme " + this.name + " is already present and cannot be overriden");
        }
    }

    public String getName() {
        return this.name;
    }

    public void publishReplicationEvent(WanReplicationEvent event) {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            publisher.publishReplicationEvent(event);
        }
    }

    public void publishReplicationEventBackup(WanReplicationEvent event) {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            publisher.publishReplicationEventBackup(event);
        }
    }

    public void republishReplicationEvent(WanReplicationEvent wanReplicationEvent) {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof InternalWanReplicationPublisher)) continue;
            ((InternalWanReplicationPublisher)publisher).republishReplicationEvent(wanReplicationEvent);
        }
    }

    public Map<String, LocalWanPublisherStats> getStats() {
        Map<String, LocalWanPublisherStats> statsMap = MapUtil.createHashMap(this.publishers.size());
        for (Map.Entry publisherEntry : this.publishers.entrySet()) {
            WanReplicationPublisher publisher = (WanReplicationPublisher)publisherEntry.getValue();
            if (!(publisher instanceof InternalWanReplicationPublisher)) continue;
            String publisherId = (String)publisherEntry.getKey();
            LocalWanPublisherStats stats = ((InternalWanReplicationPublisher)publisher).getStats();
            if (stats == null) continue;
            statsMap.put(publisherId, stats);
        }
        return statsMap;
    }

    public void doPrepublicationChecks() {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            publisher.doPrepublicationChecks();
        }
    }

    public Map<String, Object> prepareEventContainerReplicationData(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        Map<String, Object> eventContainers = MapUtil.createHashMap(this.publishers.size());
        for (Map.Entry publisherEntry : this.publishers.entrySet()) {
            Object eventContainer;
            WanReplicationPublisher publisher = (WanReplicationPublisher)publisherEntry.getValue();
            if (!(publisher instanceof MigrationAwareWanReplicationPublisher) || (eventContainer = ((MigrationAwareWanReplicationPublisher)((Object)publisher)).prepareEventContainerReplicationData(event, namespaces)) == null) continue;
            String publisherId = (String)publisherEntry.getKey();
            eventContainers.put(publisherId, eventContainer);
        }
        return eventContainers;
    }

    public void collectAllServiceNamespaces(PartitionReplicationEvent event, Set<ServiceNamespace> namespaces) {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof MigrationAwareWanReplicationPublisher)) continue;
            ((MigrationAwareWanReplicationPublisher)((Object)publisher)).collectAllServiceNamespaces(event, namespaces);
        }
    }

    public void destroyMapData(String mapName) {
        for (WanReplicationPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof InternalWanReplicationPublisher)) continue;
            ((InternalWanReplicationPublisher)publisher).destroyMapData(mapName);
        }
    }
}

