/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.management;

import com.hazelcast.client.impl.protocol.codec.MCGetMapConfigCodec;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;

public class MCMapConfig {
    private boolean readBackupData;
    private int maxSize;
    private int backupCount;
    private int maxIdleSeconds;
    private int asyncBackupCount;
    private int timeToLiveSeconds;
    private String mergePolicy;
    private MaxSizePolicy maxSizePolicy;
    private EvictionPolicy evictionPolicy;
    private InMemoryFormat inMemoryFormat;

    public static MCMapConfig fromResponse(MCGetMapConfigCodec.ResponseParameters params) {
        MCMapConfig config = new MCMapConfig();
        config.inMemoryFormat = InMemoryFormat.getById(params.inMemoryFormat);
        config.backupCount = params.backupCount;
        config.asyncBackupCount = params.asyncBackupCount;
        config.timeToLiveSeconds = params.timeToLiveSeconds;
        config.maxIdleSeconds = params.maxIdleSeconds;
        config.maxSize = params.maxSize;
        config.maxSizePolicy = MaxSizePolicy.getById(params.maxSizePolicy);
        config.readBackupData = params.readBackupData;
        config.evictionPolicy = EvictionPolicy.getById(params.evictionPolicy);
        config.mergePolicy = params.mergePolicy;
        return config;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public MaxSizePolicy getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public boolean isReadBackupData() {
        return this.readBackupData;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }
}

