/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class ExecutorServiceCancelOnMemberCodec {
    public static final int REQUEST_MESSAGE_TYPE = 525312;
    public static final int RESPONSE_MESSAGE_TYPE = 525313;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_MEMBER_UUID_FIELD_OFFSET = 33;
    private static final int REQUEST_INTERRUPT_FIELD_OFFSET = 50;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 51;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private ExecutorServiceCancelOnMemberCodec() {
    }

    public static ClientMessage encodeRequest(UUID uuid, UUID memberUUID, boolean interrupt) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("ExecutorService.CancelOnMember");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[51], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 525312);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 33, memberUUID);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 50, interrupt);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.memberUUID = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 33);
        request.interrupt = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 50);
        return request;
    }

    public static ClientMessage encodeResponse(boolean response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 525313);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public boolean response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID uuid;
        public UUID memberUUID;
        public boolean interrupt;
    }
}

