/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.QueryConstants;
import java.io.IOException;
import java.util.regex.Pattern;

public class AttributeConfig
implements IdentifiedDataSerializable {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_]*$");
    private String name;
    private String extractorClassName;

    public AttributeConfig() {
    }

    public AttributeConfig(String name, String extractorClassName) {
        this.setName(name);
        this.setExtractorClassName(extractorClassName);
    }

    public AttributeConfig(AttributeConfig config) {
        this.name = config.getName();
        this.extractorClassName = config.getExtractorClassName();
    }

    public String getName() {
        return this.name;
    }

    public AttributeConfig setName(String name) {
        this.name = AttributeConfig.checkName(name);
        return this;
    }

    private static String checkName(String name) {
        Preconditions.checkHasText(name, "Map attribute name must contain text");
        AttributeConfig.checkNameValid(name);
        AttributeConfig.checkNotQueryConstant(name);
        return name;
    }

    private static void checkNameValid(String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Map attribute name is invalid. It may contain upper-case and lower-case letters, digits and underscores but an underscore may not be located at the first position).");
        }
    }

    private static void checkNotQueryConstant(String name) {
        for (QueryConstants constant : QueryConstants.values()) {
            if (!name.equals(constant.value())) continue;
            throw new IllegalArgumentException(String.format("Map attribute name must not contain query constant '%s'", constant.value()));
        }
    }

    public String getExtractorClassName() {
        return this.extractorClassName;
    }

    public AttributeConfig setExtractorClassName(String extractorClassName) {
        this.extractorClassName = Preconditions.checkHasText(extractorClassName, "Map attribute extractor must contain text");
        return this;
    }

    public String toString() {
        return "AttributeConfig{name='" + this.name + '\'' + "extractorClassName='" + this.extractorClassName + '\'' + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.extractorClassName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.extractorClassName = in.readUTF();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeConfig that = (AttributeConfig)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.extractorClassName != null ? this.extractorClassName.equals(that.extractorClassName) : that.extractorClassName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.extractorClassName != null ? this.extractorClassName.hashCode() : 0);
        return result;
    }
}

