/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AuthenticationConfig;
import java.util.Objects;

public class TlsAuthenticationConfig
implements AuthenticationConfig {
    private String roleAttribute;

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public TlsAuthenticationConfig setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
        return this;
    }

    @Override
    public LoginModuleConfig[] asLoginModuleConfigs() {
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig("com.hazelcast.security.loginimpl.X509CertificateLoginModule", LoginModuleConfig.LoginModuleUsage.REQUIRED);
        if (this.roleAttribute != null) {
            loginModuleConfig.getProperties().setProperty("roleAttribute", this.roleAttribute);
        }
        return new LoginModuleConfig[]{loginModuleConfig};
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TlsAuthenticationConfig [roleAttribute=").append(this.roleAttribute).append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.roleAttribute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TlsAuthenticationConfig other = (TlsAuthenticationConfig)obj;
        return Objects.equals(this.roleAttribute, other.roleAttribute);
    }
}

