/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SemaphoreAcquireCodec;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.client.AbstractCPMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.AcquirePermitsOp;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.SemaphorePermission;
import java.security.Permission;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class AcquirePermitsMessageTask
extends AbstractCPMessageTask<SemaphoreAcquireCodec.RequestParameters> {
    public AcquirePermitsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        RaftService service = (RaftService)this.nodeEngine.getService("hz:core:raft");
        AcquirePermitsOp op = new AcquirePermitsOp(((SemaphoreAcquireCodec.RequestParameters)this.parameters).name, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).sessionId, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).threadId, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).invocationUid, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).permits, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).timeoutMs);
        service.getInvocationManager().invoke(((SemaphoreAcquireCodec.RequestParameters)this.parameters).groupId, op).whenCompleteAsync((BiConsumer)this);
    }

    @Override
    protected SemaphoreAcquireCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SemaphoreAcquireCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return SemaphoreAcquireCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:raft:semaphoreService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new SemaphorePermission(((SemaphoreAcquireCodec.RequestParameters)this.parameters).name, "acquire");
    }

    @Override
    public String getDistributedObjectName() {
        return ((SemaphoreAcquireCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return ((SemaphoreAcquireCodec.RequestParameters)this.parameters).timeoutMs >= 0L ? "tryAcquire" : "acquire";
    }

    @Override
    public Object[] getParameters() {
        if (((SemaphoreAcquireCodec.RequestParameters)this.parameters).timeoutMs > 0L) {
            return new Object[]{((SemaphoreAcquireCodec.RequestParameters)this.parameters).permits, ((SemaphoreAcquireCodec.RequestParameters)this.parameters).timeoutMs, TimeUnit.MILLISECONDS};
        }
        return new Object[]{((SemaphoreAcquireCodec.RequestParameters)this.parameters).permits};
    }
}

