/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.serialization.impl.AbstractCollectionStreamSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

public class PriorityBlockingQueueStreamSerializer<E>
extends AbstractCollectionStreamSerializer<PriorityBlockingQueue<E>> {
    @Override
    public int getTypeId() {
        return -45;
    }

    @Override
    public void write(ObjectDataOutput out, PriorityBlockingQueue<E> collection) throws IOException {
        out.writeObject(collection.comparator());
        super.write(out, collection);
    }

    @Override
    public PriorityBlockingQueue<E> read(ObjectDataInput in) throws IOException {
        Comparator comparator = (Comparator)in.readObject();
        int size = in.readInt();
        PriorityBlockingQueue collection = new PriorityBlockingQueue(Math.max(1, size), comparator);
        return this.deserializeEntries(in, size, collection);
    }
}

