/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ErrorsCodec;
import com.hazelcast.client.impl.protocol.exception.ErrorHolder;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.ConsistencyLostException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.exception.CannotReplicateException;
import com.hazelcast.cp.exception.LeaderDemotedException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.exception.StaleAppendRequestException;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.session.SessionExpiredException;
import com.hazelcast.cp.lock.exception.LockAcquireLimitReachedException;
import com.hazelcast.cp.lock.exception.LockOwnershipLostException;
import com.hazelcast.crdt.MutationDisallowedException;
import com.hazelcast.crdt.TargetNotReplicaException;
import com.hazelcast.durableexecutor.StaleTaskIdException;
import com.hazelcast.flakeidgen.impl.NodeIdOutOfRangeException;
import com.hazelcast.internal.cluster.impl.ConfigMismatchException;
import com.hazelcast.internal.cluster.impl.VersionMismatchException;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.query.QueryException;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.scheduledexecutor.DuplicateTaskException;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionTimedOutException;
import com.hazelcast.wan.WanQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;

public class ClientExceptions {
    private final Map<Class, Integer> classToInt = new HashMap<Class, Integer>();

    public ClientExceptions(boolean jcacheAvailable) {
        if (jcacheAvailable) {
            this.register(4, CacheException.class);
            this.register(5, CacheLoaderException.class);
            this.register(7, CacheWriterException.class);
            this.register(16, EntryProcessorException.class);
        }
        this.register(1, ArrayIndexOutOfBoundsException.class);
        this.register(2, ArrayStoreException.class);
        this.register(3, AuthenticationException.class);
        this.register(6, CacheNotExistsException.class);
        this.register(8, CallerNotMemberException.class);
        this.register(9, CancellationException.class);
        this.register(10, ClassCastException.class);
        this.register(11, ClassNotFoundException.class);
        this.register(12, ConcurrentModificationException.class);
        this.register(13, ConfigMismatchException.class);
        this.register(14, DistributedObjectDestroyedException.class);
        this.register(15, EOFException.class);
        this.register(17, ExecutionException.class);
        this.register(18, HazelcastException.class);
        this.register(19, HazelcastInstanceNotActiveException.class);
        this.register(20, HazelcastOverloadException.class);
        this.register(21, HazelcastSerializationException.class);
        this.register(22, IOException.class);
        this.register(23, IllegalArgumentException.class);
        this.register(24, IllegalAccessException.class);
        this.register(25, IllegalAccessError.class);
        this.register(26, IllegalMonitorStateException.class);
        this.register(27, IllegalStateException.class);
        this.register(28, IllegalThreadStateException.class);
        this.register(29, IndexOutOfBoundsException.class);
        this.register(30, InterruptedException.class);
        this.register(31, AddressUtil.InvalidAddressException.class);
        this.register(32, InvalidConfigurationException.class);
        this.register(33, MemberLeftException.class);
        this.register(34, NegativeArraySizeException.class);
        this.register(35, NoSuchElementException.class);
        this.register(36, NotSerializableException.class);
        this.register(37, NullPointerException.class);
        this.register(38, OperationTimeoutException.class);
        this.register(39, PartitionMigratingException.class);
        this.register(40, QueryException.class);
        this.register(41, QueryResultSizeExceededException.class);
        this.register(42, SplitBrainProtectionException.class);
        this.register(43, ReachedMaxSizeException.class);
        this.register(44, RejectedExecutionException.class);
        this.register(45, ResponseAlreadySentException.class);
        this.register(46, RetryableHazelcastException.class);
        this.register(47, RetryableIOException.class);
        this.register(48, RuntimeException.class);
        this.register(49, SecurityException.class);
        this.register(50, SocketException.class);
        this.register(51, StaleSequenceException.class);
        this.register(52, TargetDisconnectedException.class);
        this.register(53, TargetNotMemberException.class);
        this.register(54, TimeoutException.class);
        this.register(55, TopicOverloadException.class);
        this.register(56, TransactionException.class);
        this.register(57, TransactionNotActiveException.class);
        this.register(58, TransactionTimedOutException.class);
        this.register(59, URISyntaxException.class);
        this.register(60, UTFDataFormatException.class);
        this.register(61, UnsupportedOperationException.class);
        this.register(62, WrongTargetException.class);
        this.register(63, XAException.class);
        this.register(64, AccessControlException.class);
        this.register(65, LoginException.class);
        this.register(66, UnsupportedCallbackException.class);
        this.register(67, NoDataMemberInClusterException.class);
        this.register(68, ReplicatedMapCantBeCreatedOnLiteMemberException.class);
        this.register(69, MaxMessageSizeExceeded.class);
        this.register(70, WanQueueFullException.class);
        this.register(71, AssertionError.class);
        this.register(72, OutOfMemoryError.class);
        this.register(73, StackOverflowError.class);
        this.register(74, NativeOutOfMemoryError.class);
        this.register(75, ServiceNotFoundException.class);
        this.register(76, StaleTaskIdException.class);
        this.register(77, DuplicateTaskException.class);
        this.register(78, StaleTaskException.class);
        this.register(79, LocalMemberResetException.class);
        this.register(80, IndeterminateOperationStateException.class);
        this.register(81, NodeIdOutOfRangeException.class);
        this.register(82, TargetNotReplicaException.class);
        this.register(83, MutationDisallowedException.class);
        this.register(84, ConsistencyLostException.class);
        this.register(85, SessionExpiredException.class);
        this.register(86, WaitKeyCancelledException.class);
        this.register(87, LockAcquireLimitReachedException.class);
        this.register(88, LockOwnershipLostException.class);
        this.register(89, CPGroupDestroyedException.class);
        this.register(90, CannotReplicateException.class);
        this.register(91, LeaderDemotedException.class);
        this.register(92, StaleAppendRequestException.class);
        this.register(93, NotLeaderException.class);
        this.register(94, VersionMismatchException.class);
    }

    public ClientMessage createExceptionMessage(Throwable throwable) {
        LinkedList<ErrorHolder> errorHolders = new LinkedList<ErrorHolder>();
        errorHolders.add(this.convertToErrorHolder(throwable));
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            errorHolders.add(this.convertToErrorHolder(cause));
        }
        return ErrorsCodec.encode(errorHolders);
    }

    private ErrorHolder convertToErrorHolder(Throwable t) {
        int errorCode = this.getErrorCode(t);
        return new ErrorHolder(errorCode, t.getClass().getName(), t.getMessage(), Arrays.asList(t.getStackTrace()));
    }

    public void register(int errorCode, Class clazz) {
        Integer currentCode = this.classToInt.get(clazz);
        if (currentCode != null) {
            throw new HazelcastException("Class " + clazz.getName() + " already added with code: " + currentCode);
        }
        this.classToInt.put(clazz, errorCode);
    }

    private int getErrorCode(Throwable e) {
        Integer errorCode = this.classToInt.get(e.getClass());
        if (errorCode == null) {
            return 0;
        }
        return errorCode;
    }

    boolean isKnownClass(Class<? extends Throwable> aClass) {
        return this.classToInt.containsKey(aClass);
    }
}

