/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;

public class GetCacheEntryViewEntryProcessor
implements EntryProcessor<Object, Object, CacheEntryView>,
IdentifiedDataSerializable,
ReadOnly {
    public CacheEntryView process(MutableEntry mutableEntry, Object ... objects) throws EntryProcessorException {
        CacheEntryProcessorEntry entry = (CacheEntryProcessorEntry)mutableEntry;
        if (entry.getRecord() == null) {
            return null;
        }
        return new CacheBrowserEntryView(entry);
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 59;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }

    public static class CacheBrowserEntryView
    implements CacheEntryView<Object, Object>,
    IdentifiedDataSerializable {
        private Object value;
        private long expirationTime;
        private long creationTime;
        private long lastAccessTime;
        private long accessHit;
        private ExpiryPolicy expiryPolicy;

        public CacheBrowserEntryView() {
        }

        CacheBrowserEntryView(CacheEntryProcessorEntry entry) {
            this.value = entry.getValue();
            Object record = entry.getRecord();
            this.expirationTime = record.getExpirationTime();
            this.creationTime = record.getCreationTime();
            this.lastAccessTime = record.getLastAccessTime();
            this.accessHit = record.getHits();
            this.expiryPolicy = (ExpiryPolicy)record.getExpiryPolicy();
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public long getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public long getHits() {
            return this.accessHit;
        }

        public ExpiryPolicy getExpiryPolicy() {
            return this.expiryPolicy;
        }

        @Override
        public int getFactoryId() {
            return CacheDataSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 58;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.value);
            out.writeLong(this.expirationTime);
            out.writeLong(this.creationTime);
            out.writeLong(this.lastAccessTime);
            out.writeLong(this.accessHit);
            out.writeObject(this.expiryPolicy);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.value = in.readObject();
            this.expirationTime = in.readLong();
            this.creationTime = in.readLong();
            this.lastAccessTime = in.readLong();
            this.accessHit = in.readLong();
            this.expiryPolicy = (ExpiryPolicy)in.readObject();
        }
    }
}

