/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class MCGetClusterMetadataCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200E00;
    public static final int RESPONSE_MESSAGE_TYPE = 2100737;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_CURRENT_STATE_FIELD_OFFSET = 13;
    private static final int RESPONSE_CLUSTER_TIME_FIELD_OFFSET = 14;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 22;

    private MCGetClusterMetadataCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.GetClusterMetadata");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200E00);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        return request;
    }

    public static ClientMessage encodeResponse(byte currentState, String memberVersion, @Nullable String jetVersion, long clusterTime) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[22], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2100737);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 13, currentState);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 14, clusterTime);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, memberVersion);
        CodecUtil.encodeNullable(clientMessage, jetVersion, StringCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.currentState = FixedSizeTypesCodec.decodeByte(initialFrame.content, 13);
        response.clusterTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 14);
        response.memberVersion = StringCodec.decode(iterator);
        response.jetVersion = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public byte currentState;
        public String memberVersion;
        @Nullable
        public String jetVersion;
        public long clusterTime;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
    }
}

