/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.handler;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.dto.AppendSuccessResponse;
import com.hazelcast.cp.internal.raft.impl.handler.AbstractResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.state.FollowerState;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.QueryState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;

public class AppendSuccessResponseHandlerTask
extends AbstractResponseHandlerTask {
    private final AppendSuccessResponse resp;

    public AppendSuccessResponseHandlerTask(RaftNodeImpl raftNode, AppendSuccessResponse response) {
        super(raftNode);
        this.resp = response;
    }

    @Override
    protected void handleResponse() {
        RaftState state = this.raftNode.state();
        if (state.role() != RaftRole.LEADER) {
            this.logger.warning("Ignored " + this.resp + ". We are not LEADER anymore.");
            return;
        }
        assert (this.resp.term() <= state.term()) : "Invalid " + this.resp + " for current term: " + state.term();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received " + this.resp);
        }
        if (this.updateFollowerIndices(state)) {
            if (!this.raftNode.tryAdvanceCommitIndex()) {
                this.trySendAppendRequest(state);
            }
        } else {
            this.raftNode.tryRunQueries();
        }
        this.checkIfQueryAckNeeded(state);
    }

    private boolean updateFollowerIndices(RaftState state) {
        RaftEndpoint follower = this.resp.follower();
        LeaderState leaderState = state.leaderState();
        FollowerState followerState = leaderState.getFollowerState(follower);
        QueryState queryState = leaderState.queryState();
        if (queryState.tryAck(this.resp.queryRound(), follower) && this.logger.isFineEnabled()) {
            this.logger.fine("Ack from " + follower + " for query round: " + this.resp.queryRound());
        }
        long matchIndex = followerState.matchIndex();
        long followerLastLogIndex = this.resp.lastLogIndex();
        if (followerLastLogIndex > matchIndex) {
            followerState.appendRequestAckReceived();
            long newNextIndex = followerLastLogIndex + 1L;
            followerState.matchIndex(followerLastLogIndex);
            followerState.nextIndex(newNextIndex);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Updated match index: " + followerLastLogIndex + " and next index: " + newNextIndex + " for follower: " + follower);
            }
            return true;
        }
        if (followerLastLogIndex == matchIndex) {
            followerState.appendRequestAckReceived();
        } else if (this.logger.isFineEnabled()) {
            this.logger.fine("Will not update match index for follower: " + follower + ". follower last log index: " + followerLastLogIndex + ", match index: " + matchIndex);
        }
        return false;
    }

    private void checkIfQueryAckNeeded(RaftState state) {
        QueryState queryState = state.leaderState().queryState();
        if (queryState.isAckNeeded(this.resp.follower(), state.majority())) {
            this.raftNode.sendAppendRequest(this.resp.follower());
        }
    }

    private void trySendAppendRequest(RaftState state) {
        long followerLastLogIndex = this.resp.lastLogIndex();
        if (state.log().lastLogOrSnapshotIndex() > followerLastLogIndex || state.commitIndex() == followerLastLogIndex) {
            this.raftNode.sendAppendRequest(this.resp.follower());
        }
    }

    @Override
    protected RaftEndpoint sender() {
        return this.resp.follower();
    }
}

