/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.executor.LocalExecutorStats;
import com.hazelcast.executor.impl.CancellableDelegatingFuture;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.executor.impl.ExecutionCallbackAdapter;
import com.hazelcast.executor.impl.ExecutionCallbackAdapterFactory;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.executor.impl.operations.CallableTaskOperation;
import com.hazelcast.executor.impl.operations.MemberCallableTaskOperation;
import com.hazelcast.executor.impl.operations.ShutdownOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutorServiceProxy
extends AbstractDistributedObject<DistributedExecutorService>
implements IExecutorService {
    public static final int SYNC_FREQUENCY = 100;
    public static final int SYNC_DELAY_MS = 10;
    private static final AtomicIntegerFieldUpdater<ExecutorServiceProxy> CONSECUTIVE_SUBMITS = AtomicIntegerFieldUpdater.newUpdater(ExecutorServiceProxy.class, "consecutiveSubmits");
    private final FutureUtil.ExceptionHandler shutdownExceptionHandler = new FutureUtil.ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable != null) {
                if (throwable instanceof SplitBrainProtectionException) {
                    ExceptionUtil.sneakyThrow(throwable);
                }
                if (throwable.getCause() instanceof SplitBrainProtectionException) {
                    ExceptionUtil.sneakyThrow(throwable.getCause());
                }
            }
            if (ExecutorServiceProxy.this.logger.isLoggable(Level.FINEST)) {
                ExecutorServiceProxy.this.logger.log(Level.FINEST, "Exception while ExecutorService shutdown", throwable);
            }
        }
    };
    private final String name;
    private final Random random = new Random(-System.currentTimeMillis());
    private final int partitionCount;
    private final ILogger logger;
    private volatile int consecutiveSubmits;
    private volatile long lastSubmitTime;

    public ExecutorServiceProxy(String name, NodeEngine nodeEngine, DistributedExecutorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.logger = nodeEngine.getLogger(ExecutorServiceProxy.class);
        this.getLocalExecutorStats();
    }

    @Override
    public void execute(@Nonnull Runnable command, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    @Override
    public void executeOnMembers(@Nonnull Runnable command, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    @Override
    public <T> Future<T> submit(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    public void submit(@Nonnull Runnable task, @Nonnull MemberSelector memberSelector, @Nullable ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public void submitToMembers(@Nonnull Runnable task, @Nonnull MemberSelector memberSelector, @Nonnull MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public <T> void submit(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector, @Nullable ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    @Override
    public <T> void submitToMembers(@Nonnull Callable<T> task, @Nonnull MemberSelector memberSelector, @Nonnull MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submit(callable);
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(@Nonnull Runnable command) {
        Preconditions.checkNotNull(command, "Command must not be null");
        return new RunnableAdapter(command);
    }

    @Override
    public void executeOnKeyOwner(@Nonnull Runnable command, @Nonnull Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner(callable, key);
    }

    @Override
    public void executeOnMember(@Nonnull Runnable command, @Nonnull Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember(callable, member);
    }

    @Override
    public void executeOnMembers(@Nonnull Runnable command, @Nonnull Collection<Member> members) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMembers(callable, members);
    }

    @Override
    public void executeOnAllMembers(@Nonnull Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToAllMembers(callable);
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable task) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submit(callable);
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable task, T result) {
        Preconditions.checkNotNull(task, "task must not be null");
        this.checkNotShutdown();
        NodeEngine nodeEngine = this.getNodeEngine();
        RunnableAdapter<T> callable = this.createRunnableAdapter(task);
        Data callableData = nodeEngine.toData(callable);
        UUID uuid = UuidUtil.newUnsecureUUID();
        int partitionId = this.getTaskPartitionId(callable);
        Operation op = new CallableTaskOperation(this.name, uuid, callableData).setPartitionId(partitionId);
        InvocationFuture future = this.invokeOnPartition(op);
        boolean sync = this.checkSync();
        if (sync) {
            try {
                future.get();
            }
            catch (Exception exception) {
                this.logger.warning(exception);
            }
            return InternalCompletableFuture.newCompletedFuture(result);
        }
        return new CancellableDelegatingFuture<T>(future, result, nodeEngine, uuid, partitionId);
    }

    private void checkNotShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.getRejectionMessage());
        }
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        Preconditions.checkNotNull(task, "task must not be null");
        int partitionId = this.getTaskPartitionId(task);
        return this.submitToPartitionOwner(task, partitionId, false);
    }

    @Nonnull
    private <T> Future<T> submitToPartitionOwner(@Nonnull Callable<T> task, int partitionId, boolean preventSync) {
        Preconditions.checkNotNull(task, "task must not be null");
        this.checkNotShutdown();
        NodeEngine nodeEngine = this.getNodeEngine();
        Data taskData = nodeEngine.toData(task);
        UUID uuid = UuidUtil.newUnsecureUUID();
        boolean sync = !preventSync && this.checkSync();
        Operation op = new CallableTaskOperation(this.name, uuid, taskData).setPartitionId(partitionId);
        InvocationFuture future = this.invokeOnPartition(op);
        if (sync) {
            return ExecutorServiceProxy.completedSynchronously(future, nodeEngine.getSerializationService());
        }
        return new CancellableDelegatingFuture(future, nodeEngine, uuid, partitionId);
    }

    private boolean checkSync() {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            CONSECUTIVE_SUBMITS.set(this, 0);
        } else if (CONSECUTIVE_SUBMITS.incrementAndGet(this) % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        return sync;
    }

    private <T> int getTaskPartitionId(Callable<T> task) {
        Object partitionKey;
        if (task instanceof PartitionAware && (partitionKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            return this.getNodeEngine().getPartitionService().getPartitionId(partitionKey);
        }
        return this.random.nextInt(this.partitionCount);
    }

    @Override
    public <T> Future<T> submitToKeyOwner(@Nonnull Callable<T> task, @Nonnull Object key) {
        Preconditions.checkNotNull(key, "key must not be null");
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToPartitionOwner(task, nodeEngine.getPartitionService().getPartitionId(key), false);
    }

    @Override
    public <T> Future<T> submitToMember(@Nonnull Callable<T> task, @Nonnull Member member) {
        Preconditions.checkNotNull(task, "task must not be null");
        Preconditions.checkNotNull(member, "member must not be null");
        this.checkNotShutdown();
        Data taskData = this.getNodeEngine().toData(task);
        return this.submitToMember(taskData, member);
    }

    private <T> Future<T> submitToMember(@Nonnull Data taskData, @Nonnull Member member) {
        NodeEngine nodeEngine = this.getNodeEngine();
        UUID uuid = UuidUtil.newUnsecureUUID();
        Address target = member.getAddress();
        boolean sync = this.checkSync();
        MemberCallableTaskOperation op = new MemberCallableTaskOperation(this.name, uuid, taskData);
        InvocationFuture future = nodeEngine.getOperationService().invokeOnTarget("hz:impl:executorService", op, target);
        if (sync) {
            return ExecutorServiceProxy.completedSynchronously(future, nodeEngine.getSerializationService());
        }
        return new CancellableDelegatingFuture(future, nodeEngine, uuid, target);
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(@Nonnull Callable<T> task, @Nonnull Collection<Member> members) {
        Preconditions.checkNotNull(task, "task must not be null");
        Preconditions.checkNotNull(members, "members must not be null");
        this.checkNotShutdown();
        Data taskData = this.getNodeEngine().toData(task);
        Map<Member, Future<T>> futures = MapUtil.createHashMap(members.size());
        for (Member member : members) {
            futures.put(member, this.submitToMember(taskData, member));
        }
        return futures;
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(@Nonnull Callable<T> task) {
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.submitToMembers(task, nodeEngine.getClusterService().getMembers());
    }

    public void submit(@Nonnull Runnable task, @Nullable ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submit(callable, callback);
    }

    public void submitToKeyOwner(@Nonnull Runnable task, @Nonnull Object key, @Nonnull ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToKeyOwner(callable, key, callback);
    }

    public void submitToMember(@Nonnull Runnable task, @Nonnull Member member, @Nullable ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMember(callable, member, callback);
    }

    @Override
    public void submitToMembers(@Nonnull Runnable task, @Nonnull Collection<Member> members, @Nonnull MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToMembers(callable, members, callback);
    }

    @Override
    public void submitToAllMembers(@Nonnull Runnable task, @Nonnull MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToAllMembers(callable, callback);
    }

    private <T> void submitToPartitionOwner(@Nonnull Callable<T> task, @Nullable ExecutionCallback<T> callback, int partitionId) {
        this.checkNotShutdown();
        Preconditions.checkNotNull(task, "task must not be null");
        NodeEngine nodeEngine = this.getNodeEngine();
        Data taskData = nodeEngine.toData(task);
        CallableTaskOperation op = new CallableTaskOperation(this.name, null, taskData);
        OperationService operationService = nodeEngine.getOperationService();
        InvocationFuture future = operationService.createInvocationBuilder("hz:impl:executorService", (Operation)op, partitionId).invoke();
        if (callback != null) {
            future.whenCompleteAsync(new ExecutionCallbackAdapter<T>(callback)).whenCompleteAsync((v, t) -> {
                if (t instanceof RejectedExecutionException) {
                    callback.onFailure((Throwable)t);
                }
            });
        }
    }

    @Override
    public <T> void submit(@Nonnull Callable<T> task, @Nullable ExecutionCallback<T> callback) {
        int partitionId = this.getTaskPartitionId(task);
        this.submitToPartitionOwner(task, callback, partitionId);
    }

    @Override
    public <T> void submitToKeyOwner(@Nonnull Callable<T> task, @Nonnull Object key, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(key, "key must not be null");
        Preconditions.checkNotNull(task, "task must not be null");
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToPartitionOwner(task, callback, nodeEngine.getPartitionService().getPartitionId(key));
    }

    private <T> void submitToMember(@Nonnull Data taskData, @Nonnull Member member, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(member, "member must not be null");
        this.checkNotShutdown();
        NodeEngine nodeEngine = this.getNodeEngine();
        UUID uuid = UuidUtil.newUnsecureUUID();
        MemberCallableTaskOperation op = new MemberCallableTaskOperation(this.name, uuid, taskData);
        OperationService operationService = nodeEngine.getOperationService();
        Address address = member.getAddress();
        InvocationFuture future = operationService.createInvocationBuilder("hz:impl:executorService", (Operation)op, address).invoke();
        if (callback != null) {
            future.whenCompleteAsync(new ExecutionCallbackAdapter<T>(callback)).whenCompleteAsync((v, t) -> {
                if (t instanceof RejectedExecutionException) {
                    callback.onFailure((Throwable)t);
                }
            });
        }
    }

    @Override
    public <T> void submitToMember(@Nonnull Callable<T> task, @Nonnull Member member, @Nullable ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, "task must not be null");
        this.checkNotShutdown();
        Data taskData = this.getNodeEngine().toData(task);
        this.submitToMember(taskData, member, callback);
    }

    private String getRejectionMessage() {
        return "ExecutorService[" + this.name + "] is shutdown! In order to create a new ExecutorService with name '" + this.name + "', you need to destroy current ExecutorService first!";
    }

    @Override
    public <T> void submitToMembers(@Nonnull Callable<T> task, @Nonnull Collection<Member> members, @Nonnull MultiExecutionCallback callback) {
        Preconditions.checkNotNull(task, "task must not be null");
        Preconditions.checkNotNull(members, "members must not be null");
        NodeEngine nodeEngine = this.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(ExecutionCallbackAdapterFactory.class);
        ExecutionCallbackAdapterFactory executionCallbackFactory = new ExecutionCallbackAdapterFactory(logger, members, callback);
        Data taskData = nodeEngine.toData(task);
        for (Member member : members) {
            this.submitToMember(taskData, member, executionCallbackFactory.callbackFor(member));
        }
    }

    @Override
    public <T> void submitToAllMembers(@Nonnull Callable<T> task, @Nonnull MultiExecutionCallback callback) {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.submitToMembers(task, nodeEngine.getClusterService().getMembers(), callback);
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkNotNull(tasks, "tasks must not be null");
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            futures.add(this.submit(callable));
        }
        for (Future future : futures) {
            result.add(ExecutorServiceProxy.completedSynchronously(future, this.getNodeEngine().getSerializationService()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit, "unit must not be null");
        Preconditions.checkNotNull(tasks, "tasks must not be null");
        long timeoutNanos = unit.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            ArrayList<Future<T>> arrayList;
            for (Callable<T> task : tasks) {
                long start = System.nanoTime();
                int partitionId = this.getTaskPartitionId(task);
                futures.add(this.submitToPartitionOwner(task, partitionId, true));
                timeoutNanos -= System.nanoTime() - start;
            }
            if (timeoutNanos <= 0L) {
                arrayList = futures;
                return arrayList;
            }
            done = this.wait(timeoutNanos, futures);
            arrayList = futures;
            return arrayList;
        }
        catch (Throwable t) {
            this.logger.severe(t);
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                ExecutorServiceProxy.cancelAll(futures);
            }
        }
    }

    private <T> boolean wait(long timeoutNanos, List<Future<T>> futures) throws InterruptedException {
        boolean done = true;
        int size = futures.size();
        for (int i = 0; i < size; ++i) {
            ExecutionException value;
            long start = System.nanoTime();
            try {
                Future<T> future = futures.get(i);
                value = future.get(timeoutNanos, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException e) {
                value = e;
            }
            catch (TimeoutException e) {
                done = false;
                for (int l = i; l < size; ++l) {
                    Future<T> f = futures.get(i);
                    if (!f.isDone()) continue;
                    futures.set(l, ExecutorServiceProxy.completedSynchronously(f, this.getNodeEngine().getSerializationService()));
                }
                break;
            }
            futures.set(i, InternalCompletableFuture.newCompletedFuture(value));
            timeoutNanos -= System.nanoTime() - start;
        }
        return done;
    }

    private static <T> void cancelAll(List<Future<T>> result) {
        for (Future<T> aResult : result) {
            aResult.cancel(true);
        }
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void throwNotActiveException() {
        throw new RejectedExecutionException();
    }

    @Override
    public boolean isShutdown() {
        try {
            return ((DistributedExecutorService)this.getService()).isShutdown(this.name);
        }
        catch (HazelcastInstanceNotActiveException e) {
            return true;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit, "unit must not be null");
        return false;
    }

    @Override
    public void shutdown() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Set<Member> members = nodeEngine.getClusterService().getMembers();
        OperationService operationService = nodeEngine.getOperationService();
        LinkedList<InvocationFuture<Object>> calls = new LinkedList<InvocationFuture<Object>>();
        for (Member member : members) {
            InvocationFuture<Object> f = this.submitShutdownOperation(operationService, member);
            calls.add(f);
        }
        FutureUtil.waitWithDeadline(calls, 3L, TimeUnit.SECONDS, this.shutdownExceptionHandler);
    }

    private InvocationFuture<Object> submitShutdownOperation(OperationService operationService, Member member) {
        ShutdownOperation op = new ShutdownOperation(this.name);
        return operationService.invokeOnTarget(this.getServiceName(), op, member.getAddress());
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        return ((DistributedExecutorService)this.getService()).getLocalExecutorStats(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public String getName() {
        return this.name;
    }

    private ExecutorService getAsyncExecutor() {
        return this.getNodeEngine().getExecutionService().getExecutor("hz:async");
    }

    private List<Member> selectMembers(@Nonnull MemberSelector memberSelector) {
        Preconditions.checkNotNull(memberSelector, "memberSelector must not be null");
        ArrayList<Member> selected = new ArrayList<Member>();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        for (Member member : members) {
            if (!memberSelector.select(member)) continue;
            selected.add(member);
        }
        if (selected.isEmpty()) {
            throw new RejectedExecutionException("No member selected with memberSelector[" + memberSelector + "]");
        }
        return selected;
    }

    @Override
    public String toString() {
        return "IExecutorService{name='" + this.name + '\'' + '}';
    }

    private static <V> InternalCompletableFuture<V> completedSynchronously(Future<V> future, SerializationService serializationService) {
        try {
            return InternalCompletableFuture.newCompletedFuture(future.get(), serializationService);
        }
        catch (ExecutionException e) {
            return InternalCompletableFuture.completedExceptionally(e.getCause() == null ? e : e.getCause());
        }
        catch (CancellationException e) {
            InternalCompletableFuture cancelledFuture = new InternalCompletableFuture();
            future.cancel(true);
            return cancelledFuture;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return InternalCompletableFuture.completedExceptionally(e);
        }
    }
}

