/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.config.impl.ClientFailoverDomConfigProcessor;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.config.yaml.YamlElementAdapter;
import java.io.IOException;
import org.w3c.dom.Node;

public class YamlClientFailoverDomConfigProcessor
extends ClientFailoverDomConfigProcessor {
    public YamlClientFailoverDomConfigProcessor(boolean domLevel3, ClientFailoverConfig clientFailoverConfig) {
        super(domLevel3, clientFailoverConfig);
    }

    @Override
    protected void handleClients(Node node) {
        boolean clientConfigDefined = false;
        for (Node child : DomConfigHelper.childElements(node)) {
            String clientPath = this.getTextContent(child);
            try {
                ClientConfig config = new YamlClientConfigBuilder(clientPath).build();
                this.clientFailoverConfig.addClientConfig(config);
                clientConfigDefined = true;
            }
            catch (IOException e) {
                throw new InvalidConfigurationException("Could not create the config from given path : " + clientPath, e);
            }
        }
        if (!clientConfigDefined) {
            String path = ((YamlElementAdapter)node).getYamlNode().path();
            throw new InvalidConfigurationException(String.format("At least one client configuration should be defined under '%s'", path));
        }
    }
}

