/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.tcp.ClientICMPManager;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnectionManager;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.concurrent.TimeUnit;

public class HeartbeatManager
implements Runnable {
    private final TcpClientConnectionManager clientConnectionManager;
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private final ClientICMPManager clientICMPManager;

    HeartbeatManager(TcpClientConnectionManager clientConnectionManager, HazelcastClientInstanceImpl client) {
        this.clientConnectionManager = clientConnectionManager;
        this.client = client;
        HazelcastProperties properties = client.getProperties();
        this.heartbeatTimeout = properties.getPositiveMillisOrDefault(ClientProperty.HEARTBEAT_TIMEOUT);
        this.heartbeatInterval = properties.getPositiveMillisOrDefault(ClientProperty.HEARTBEAT_INTERVAL);
        this.logger = client.getLoggingService().getLogger(HeartbeatManager.class);
        ClientIcmpPingConfig icmpPingConfig = client.getClientConfig().getNetworkConfig().getClientIcmpPingConfig();
        this.clientICMPManager = new ClientICMPManager(icmpPingConfig, (ClientExecutionServiceImpl)client.getTaskScheduler(), client.getLoggingService(), clientConnectionManager, this);
    }

    public void start() {
        this.client.getTaskScheduler().scheduleWithRepetition(this, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
        this.clientICMPManager.start();
    }

    long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    @Override
    public void run() {
        if (!this.clientConnectionManager.isAlive()) {
            return;
        }
        long now = Clock.currentTimeMillis();
        for (ClientConnection connection : this.clientConnectionManager.getActiveConnections()) {
            this.checkConnection(now, connection);
        }
    }

    private void checkConnection(long now, ClientConnection connection) {
        if (!connection.isAlive()) {
            return;
        }
        if (now - connection.lastReadTimeMillis() > this.heartbeatTimeout && connection.isAlive()) {
            this.logger.warning("Heartbeat failed over the connection: " + connection);
            this.onHeartbeatStopped(connection, "Heartbeat timed out");
        }
        if (now - connection.lastWriteTimeMillis() > this.heartbeatInterval) {
            ClientMessage request = ClientPingCodec.encodeRequest();
            ClientInvocation clientInvocation = new ClientInvocation(this.client, request, null, connection);
            clientInvocation.invokeUrgent();
        }
    }

    void onHeartbeatStopped(ClientConnection connection, String reason) {
        connection.close(reason, new TargetDisconnectedException("Heartbeat timed out to connection " + connection));
    }

    public void shutdown() {
        this.clientICMPManager.shutdown();
    }
}

