/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import java.util.Random;

public class WaitStrategy {
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final double multiplier;
    private final double jitter;
    private final Random random = new Random();
    private final ILogger logger;
    private int attempt;
    private int currentBackoffMillis;
    private long clusterConnectTimeoutMillis;
    private long clusterConnectAttemptBegin;

    WaitStrategy(int initialBackoffMillis, int maxBackoffMillis, double multiplier, long clusterConnectTimeoutMillis, double jitter, ILogger logger) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.multiplier = multiplier;
        this.clusterConnectTimeoutMillis = clusterConnectTimeoutMillis;
        this.jitter = jitter;
        this.logger = logger;
    }

    public void reset() {
        this.attempt = 0;
        this.clusterConnectAttemptBegin = Clock.currentTimeMillis();
        this.currentBackoffMillis = Math.min(this.maxBackoffMillis, this.initialBackoffMillis);
    }

    public boolean sleep() {
        ++this.attempt;
        long currentTimeMillis = Clock.currentTimeMillis();
        long timePassed = currentTimeMillis - this.clusterConnectAttemptBegin;
        if (timePassed > this.clusterConnectTimeoutMillis) {
            this.logger.warning(String.format("Unable to get live cluster connection, cluster connect timeout (%d millis) is reached. Attempt %d.", this.clusterConnectTimeoutMillis, this.attempt));
            return false;
        }
        long actualSleepTime = (long)((double)this.currentBackoffMillis - (double)this.currentBackoffMillis * this.jitter + (double)this.currentBackoffMillis * this.jitter * this.random.nextDouble());
        actualSleepTime = Math.min(actualSleepTime, this.clusterConnectTimeoutMillis - timePassed);
        this.logger.warning(String.format("Unable to get live cluster connection, retry in %d ms, attempt: %d , cluster connect timeout: %d seconds , max backoff millis: %d", actualSleepTime, this.attempt, this.clusterConnectTimeoutMillis, this.maxBackoffMillis));
        try {
            Thread.sleep(actualSleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        this.currentBackoffMillis = (int)Math.min((double)this.currentBackoffMillis * this.multiplier, (double)this.maxBackoffMillis);
        return true;
    }
}

