/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListDataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlErrorCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlQueryIdCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class SqlFetchCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x210200;
    public static final int RESPONSE_MESSAGE_TYPE = 0x210201;
    private static final int REQUEST_CURSOR_BUFFER_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_ROW_PAGE_LAST_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private SqlFetchCodec() {
    }

    public static ClientMessage encodeRequest(QueryId queryId, int cursorBufferSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Sql.Fetch");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x210200);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, cursorBufferSize);
        clientMessage.add(initialFrame);
        SqlQueryIdCodec.encode(clientMessage, queryId);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.cursorBufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.queryId = SqlQueryIdCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable Collection<Collection<Data>> rowPage, boolean rowPageLast, @Nullable SqlError error) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x210201);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, rowPageLast);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encodeNullable(clientMessage, rowPage, ListDataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, error, SqlErrorCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.rowPageLast = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        response.rowPage = ListMultiFrameCodec.decodeNullable(iterator, ListDataCodec::decode);
        response.error = CodecUtil.decodeNullable(iterator, SqlErrorCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public List<List<Data>> rowPage;
        public boolean rowPageLast;
        @Nullable
        public SqlError error;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public QueryId queryId;
        public int cursorBufferSize;
    }
}

