/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.countdownlatch;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.countdownlatch.AwaitInvocationKey;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.spi.blocking.BlockingResource;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CountDownLatch
extends BlockingResource<AwaitInvocationKey>
implements IdentifiedDataSerializable {
    private volatile int round;
    private volatile int countDownFrom;
    private volatile transient int remaining;
    private final Set<UUID> countDownUids = new HashSet<UUID>();

    CountDownLatch() {
    }

    CountDownLatch(CPGroupId groupId, String name) {
        super(groupId, name);
    }

    BiTuple<Integer, Collection<AwaitInvocationKey>> countDown(UUID invocationUuid, int expectedRound) {
        if (expectedRound > this.round) {
            throw new IllegalStateException("Could not could count down the latch because expected round: " + expectedRound + " is bigger than the actual round: " + this.round + ". This can happen when CP Subsystem is used in the unsafe mode if data loss occurs after the count reaches to zero and the latch is reinitialized.");
        }
        if (expectedRound < this.round) {
            List c = Collections.emptyList();
            return BiTuple.of(0, c);
        }
        this.countDownUids.add(invocationUuid);
        int remaining = this.updateRemainingCount();
        if (remaining > 0) {
            List c = Collections.emptyList();
            return BiTuple.of(remaining, c);
        }
        Collection w = this.getAllWaitKeys();
        this.clearWaitKeys();
        return BiTuple.of(0, w);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="'round' field is updated only by a single thread.")
    boolean trySetCount(int count) {
        if (this.getRemainingCount() > 0) {
            return false;
        }
        Preconditions.checkTrue(count > 0, "cannot set non-positive count: " + count);
        this.countDownFrom = count;
        ++this.round;
        this.countDownUids.clear();
        this.updateRemainingCount();
        return true;
    }

    boolean await(AwaitInvocationKey key, boolean wait) {
        boolean success;
        boolean bl = success = this.getRemainingCount() == 0;
        if (!success && wait) {
            this.addWaitKey(key.invocationUid(), key);
        }
        return success;
    }

    int getRound() {
        return this.round;
    }

    public int getCount() {
        return this.countDownFrom;
    }

    int updateRemainingCount() {
        int rem;
        this.remaining = rem = Math.max(0, this.countDownFrom - this.countDownUids.size());
        return rem;
    }

    int getRemainingCount() {
        return this.remaining;
    }

    CountDownLatch cloneForSnapshot() {
        CountDownLatch clone = new CountDownLatch();
        this.cloneForSnapshot(clone);
        clone.round = this.round;
        clone.countDownFrom = this.countDownFrom;
        clone.countDownUids.addAll(this.countDownUids);
        return clone;
    }

    @Override
    protected void onSessionClose(long sessionId, Map<Long, Object> responses) {
    }

    @Override
    protected Collection<Long> getActivelyAttachedSessions() {
        return Collections.emptyList();
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.round);
        out.writeInt(this.countDownFrom);
        out.writeInt(this.countDownUids.size());
        for (UUID uid : this.countDownUids) {
            UUIDSerializationUtil.writeUUID(out, uid);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.round = in.readInt();
        this.countDownFrom = in.readInt();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            this.countDownUids.add(UUIDSerializationUtil.readUUID(in));
        }
        this.updateRemainingCount();
    }

    public String toString() {
        return "CountDownLatch{" + this.internalToString() + ", round=" + this.round + ", countDownFrom=" + this.countDownFrom + ", countDownUids=" + this.countDownUids + '}';
    }
}

