/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.AbstractFactoryWithPropertiesConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.config.DomConfigProcessor;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Node;

public abstract class AbstractDomConfigProcessor
implements DomConfigProcessor {
    protected final Set<String> occurrenceSet = new HashSet<String>();
    protected final boolean strict;
    final boolean domLevel3;

    protected AbstractDomConfigProcessor(boolean domLevel3) {
        this.domLevel3 = domLevel3;
        this.strict = true;
    }

    protected AbstractDomConfigProcessor(boolean domLevel3, boolean strict) {
        this.domLevel3 = domLevel3;
        this.strict = strict;
    }

    protected String getTextContent(Node node) {
        return DomConfigHelper.getTextContent(node, this.domLevel3);
    }

    protected String getAttribute(Node node, String attName) {
        if (this.strict) {
            return DomConfigHelper.getAttribute(node, attName, this.domLevel3);
        }
        String value = DomConfigHelper.getAttribute(node, attName, this.domLevel3);
        return value != null ? value : DomConfigHelper.getAttribute(node, attName.replace("-", ""), this.domLevel3);
    }

    protected Node getNamedItemNode(Node node, String attrName) {
        if (this.strict) {
            return node.getAttributes().getNamedItem(attrName);
        }
        Node attrNode = node.getAttributes().getNamedItem(attrName);
        return attrNode != null ? attrNode : node.getAttributes().getNamedItem(attrName.replace("-", ""));
    }

    protected boolean matches(String config1, String config2) {
        return this.strict ? config1 != null && config1.equals(config2) : ConfigUtils.matches(config1, config2);
    }

    protected void fillProperties(Node node, Map<String, Comparable> properties) {
        DomConfigHelper.fillProperties(node, properties, this.domLevel3);
    }

    protected void fillProperties(Node node, Properties properties) {
        DomConfigHelper.fillProperties(node, properties, this.domLevel3);
    }

    protected SocketInterceptorConfig parseSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        socketInterceptorConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("class-name", nodeName)) {
                socketInterceptorConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, socketInterceptorConfig.getProperties());
        }
        return socketInterceptorConfig;
    }

    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String value;
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("portable-version", name)) {
                value = this.getTextContent(child);
                serializationConfig.setPortableVersion(DomConfigHelper.getIntegerValue(name, value));
                continue;
            }
            if (this.matches("check-class-def-errors", name)) {
                value = this.getTextContent(child);
                serializationConfig.setCheckClassDefErrors(DomConfigHelper.getBooleanValue(value));
                continue;
            }
            if (this.matches("use-native-byte-order", name)) {
                serializationConfig.setUseNativeByteOrder(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("byte-order", name)) {
                value = this.getTextContent(child);
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if (this.matches("enable-compression", name)) {
                serializationConfig.setEnableCompression(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("enable-shared-object", name)) {
                serializationConfig.setEnableSharedObject(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allow-unsafe", name)) {
                serializationConfig.setAllowUnsafe(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("data-serializable-factories", name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("portable-factories", name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("serializers", name)) {
                this.fillSerializers(child, serializationConfig);
                continue;
            }
            if (!this.matches("java-serialization-filter", name)) continue;
            this.fillJavaSerializationFilter(child, serializationConfig);
        }
        return serializationConfig;
    }

    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("data-serializable-factory", name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addDataSerializableFactoryClass(factoryId, value);
        }
    }

    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("portable-factory", name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addPortableFactoryClass(factoryId, value);
        }
    }

    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            String value = this.getTextContent(child);
            if (this.matches("serializer", name)) {
                SerializerConfig serializerConfig = new SerializerConfig();
                String typeClassName = this.getAttribute(child, "type-class");
                String className = this.getAttribute(child, "class-name");
                serializerConfig.setTypeClassName(typeClassName);
                serializerConfig.setClassName(className);
                serializationConfig.addSerializerConfig(serializerConfig);
                continue;
            }
            if (!this.matches("global-serializer", name)) continue;
            GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
            globalSerializerConfig.setClassName(value);
            String attrValue = this.getAttribute(child, "override-java-serialization");
            boolean overrideJavaSerialization = attrValue != null && DomConfigHelper.getBooleanValue(attrValue.trim());
            globalSerializerConfig.setOverrideJavaSerialization(overrideJavaSerialization);
            serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
        }
    }

    protected void fillJavaSerializationFilter(Node node, SerializationConfig serializationConfig) {
        JavaSerializationFilterConfig filterConfig = new JavaSerializationFilterConfig();
        serializationConfig.setJavaSerializationFilterConfig(filterConfig);
        Node defaultsDisabledNode = this.getNamedItemNode(node, "defaults-disabled");
        boolean defaultsDisabled = defaultsDisabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(defaultsDisabledNode));
        filterConfig.setDefaultsDisabled(defaultsDisabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            ClassFilter list;
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("blacklist", name)) {
                list = this.parseClassFilterList(child);
                filterConfig.setBlacklist(list);
                continue;
            }
            if (!this.matches("whitelist", name)) continue;
            list = this.parseClassFilterList(child);
            filterConfig.setWhitelist(list);
        }
    }

    protected ClassFilter parseClassFilterList(Node node) {
        ClassFilter list = new ClassFilter();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("class", name)) {
                list.addClasses(this.getTextContent(child));
                continue;
            }
            if (this.matches("package", name)) {
                list.addPackages(this.getTextContent(child));
                continue;
            }
            if (!this.matches("prefix", name)) continue;
            list.addPrefixes(this.getTextContent(child));
        }
        return list;
    }

    protected SSLConfig parseSslConfig(Node node) {
        return this.fillFactoryWithPropertiesConfig(node, new SSLConfig());
    }

    protected <T extends AbstractFactoryWithPropertiesConfig<?>> T fillFactoryWithPropertiesConfig(Node node, T factoryConfig) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode));
        factoryConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("factory-class-name", nodeName)) {
                factoryConfig.setFactoryClassName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, factoryConfig.getProperties());
        }
        return factoryConfig;
    }

    protected void fillNativeMemoryConfig(Node node, NativeMemoryConfig nativeMemoryConfig) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        nativeMemoryConfig.setEnabled(enabled);
        Node allocTypeNode = this.getNamedItemNode(node, "allocator-type");
        String allocType = this.getTextContent(allocTypeNode);
        if (allocType != null && !"".equals(allocType)) {
            nativeMemoryConfig.setAllocatorType(NativeMemoryConfig.MemoryAllocatorType.valueOf(StringUtil.upperCaseInternal(allocType)));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            String value;
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("size", nodeName)) {
                value = this.getTextContent(this.getNamedItemNode(n, "value"));
                MemoryUnit unit = MemoryUnit.valueOf(this.getTextContent(this.getNamedItemNode(n, "unit")));
                MemorySize memorySize = new MemorySize(Long.parseLong(value), unit);
                nativeMemoryConfig.setSize(memorySize);
                continue;
            }
            if (this.matches("min-block-size", nodeName)) {
                value = this.getTextContent(n);
                nativeMemoryConfig.setMinBlockSize(Integer.parseInt(value));
                continue;
            }
            if (this.matches("page-size", nodeName)) {
                value = this.getTextContent(n);
                nativeMemoryConfig.setPageSize(Integer.parseInt(value));
                continue;
            }
            if (this.matches("metadata-space-percentage", nodeName)) {
                value = this.getTextContent(n);
                nativeMemoryConfig.setMetadataSpacePercentage(Float.parseFloat(value));
                continue;
            }
            if (this.matches("persistent-memory-directory", nodeName)) {
                nativeMemoryConfig.getPersistentMemoryConfig().addDirectoryConfig(new PersistentMemoryDirectoryConfig(this.getTextContent(n).trim()));
                continue;
            }
            if (!this.matches("persistent-memory", nodeName)) continue;
            this.handlePersistentMemoryConfig(nativeMemoryConfig.getPersistentMemoryConfig(), n);
        }
    }

    protected void handlePersistentMemoryConfig(PersistentMemoryConfig persistentMemoryConfig, Node node) {
        for (Node parent : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(parent);
            if (!this.matches("directories", nodeName)) continue;
            for (Node dirNode : DomConfigHelper.childElements(parent)) {
                String childNodeName = DomConfigHelper.cleanNodeName(dirNode);
                if (!this.matches("directory", childNodeName)) continue;
                Node numaNodeIdNode = this.getNamedItemNode(dirNode, "numa-node");
                int numaNodeId = numaNodeIdNode != null ? DomConfigHelper.getIntegerValue("numa-node", this.getTextContent(numaNodeIdNode)) : -1;
                String directory = this.getTextContent(dirNode).trim();
                persistentMemoryConfig.addDirectoryConfig(new PersistentMemoryDirectoryConfig(directory, numaNodeId));
            }
        }
    }

    protected void handleJaasAuthentication(RealmConfig realmConfig, Node node) {
        JaasAuthenticationConfig jaasAuthenticationConfig = new JaasAuthenticationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("login-module", nodeName)) continue;
            jaasAuthenticationConfig.addLoginModuleConfig(this.handleLoginModule(child));
        }
        realmConfig.setJaasAuthenticationConfig(jaasAuthenticationConfig);
    }

    protected LoginModuleConfig handleLoginModule(Node node) {
        Node classNameNode = this.getNamedItemNode(node, "class-name");
        String className = this.getTextContent(classNameNode);
        Node usageNode = this.getNamedItemNode(node, "usage");
        LoginModuleConfig.LoginModuleUsage usage = usageNode != null ? LoginModuleConfig.LoginModuleUsage.get(this.getTextContent(usageNode)) : LoginModuleConfig.LoginModuleUsage.REQUIRED;
        LoginModuleConfig moduleConfig = new LoginModuleConfig(className, usage);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(child, moduleConfig.getProperties());
            break;
        }
        return moduleConfig;
    }

    protected void handleInstanceTracking(Node node, InstanceTrackingConfig trackingConfig) {
        Node attrEnabled = this.getNamedItemNode(node, "enabled");
        boolean enabled = DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
        trackingConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (this.matches("file-name", name)) {
                trackingConfig.setFileName(this.getTextContent(n));
                continue;
            }
            if (!this.matches("format-pattern", name)) continue;
            trackingConfig.setFormatPattern(this.getTextContent(n));
        }
    }
}

