/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

class ConfigNode {
    private final ConfigNode parent;
    private final String name;
    private final Map<String, ConfigNode> children = new LinkedHashMap<String, ConfigNode>();
    private String value;

    ConfigNode(@Nonnull String name) {
        this(name, null);
    }

    ConfigNode(String name, ConfigNode parent) {
        Objects.requireNonNull(name);
        this.name = name;
        this.parent = parent;
    }

    String getName() {
        return this.name;
    }

    Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    void setValue(String value) {
        this.value = value;
    }

    Map<String, ConfigNode> getChildren() {
        return this.children;
    }

    Optional<ConfigNode> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public String toString() {
        return String.format("ConfigNode{name='%s', children=%s, value='%s'}", this.name, this.children, this.value);
    }
}

