/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.impl.YamlClientDomConfigProcessor;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.YamlMemberDomConfigProcessor;
import com.hazelcast.internal.config.override.ConfigOverrideElementAdapter;
import com.hazelcast.internal.config.override.ConfigOverrideValidator;
import com.hazelcast.internal.config.override.ConfigProvider;
import com.hazelcast.internal.config.override.EnvConfigProvider;
import com.hazelcast.internal.config.override.EnvVariablesConfigParser;
import com.hazelcast.internal.config.override.PropertiesToNodeConverter;
import com.hazelcast.internal.config.override.SystemPropertiesConfigParser;
import com.hazelcast.internal.config.override.SystemPropertiesConfigProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ExternalConfigurationOverride {
    private static final ILogger LOGGER = Logger.getLogger(ExternalConfigurationOverride.class);

    public Config overwriteMemberConfig(Config config) {
        return this.overwrite(config, (provider, c) -> {
            try {
                new YamlMemberDomConfigProcessor(true, (Config)c, false).buildConfig(new ConfigOverrideElementAdapter(PropertiesToNodeConverter.propsToNode(provider.properties())));
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("failed to overwrite configuration coming from " + provider.name(), e);
            }
        }, new EnvConfigProvider(EnvVariablesConfigParser.member()), new SystemPropertiesConfigProvider(SystemPropertiesConfigParser.member()));
    }

    public ClientConfig overwriteClientConfig(ClientConfig config) {
        return this.overwrite(config, (provider, c) -> {
            try {
                new YamlClientDomConfigProcessor(true, (ClientConfig)c, false).buildConfig(new ConfigOverrideElementAdapter(PropertiesToNodeConverter.propsToNode(provider.properties())));
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("failed to overwrite configuration coming from " + provider.name(), e);
            }
        }, new EnvConfigProvider(EnvVariablesConfigParser.client()), new SystemPropertiesConfigProvider(SystemPropertiesConfigParser.client()));
    }

    private <T> T overwrite(T config, BiConsumer<ConfigProvider, T> configProcessor, ConfigProvider ... providers) {
        ConfigOverrideValidator.validate(new HashSet<ConfigProvider>(Arrays.asList(providers)));
        for (ConfigProvider configProvider : providers) {
            Map<String, String> properties = configProvider.properties();
            if (properties.isEmpty()) continue;
            LOGGER.info(String.format("Detected external configuration overrides in %s: [%s]", configProvider.name(), properties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","))));
            configProcessor.accept(configProvider, (ConfigProvider)config);
        }
        return config;
    }
}

