/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterVersionListener;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionStamp;
import com.hazelcast.internal.partition.PartitionStateGenerator;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.ReadonlyInternalPartition;
import com.hazelcast.internal.partition.impl.DefaultPartitionReplicaInterceptor;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.NopPartitionReplicaInterceptor;
import com.hazelcast.internal.partition.impl.PartitionStateGeneratorImpl;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactoryFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionStateManager
implements ClusterVersionListener {
    static final long INITIAL_STAMP = 0L;
    private final Node node;
    private final ILogger logger;
    private final InternalPartitionServiceImpl partitionService;
    @Probe(name="partitionCount")
    private final int partitionCount;
    private final InternalPartitionImpl[] partitions;
    @Probe(name="stateVersion")
    @Deprecated
    private final AtomicInteger stateVersion = new AtomicInteger();
    private final PartitionStateGenerator partitionStateGenerator;
    private final MemberGroupFactory memberGroupFactory;
    private volatile boolean initialized;
    @Probe(name="stateStamp")
    private volatile long stateStamp = 0L;
    @Probe(name="memberGroupsSize")
    private volatile int memberGroupsSize;

    public PartitionStateManager(Node node, InternalPartitionServiceImpl partitionService) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.partitionService = partitionService;
        this.partitionCount = partitionService.getPartitionCount();
        this.partitions = new InternalPartitionImpl[this.partitionCount];
        DefaultPartitionReplicaInterceptor interceptor = new DefaultPartitionReplicaInterceptor(partitionService);
        PartitionReplica localReplica = PartitionReplica.from(node.getLocalMember());
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions[i] = new InternalPartitionImpl(i, localReplica, interceptor);
        }
        this.memberGroupFactory = MemberGroupFactoryFactory.newMemberGroupFactory(node.getConfig().getPartitionGroupConfig(), node.getDiscoveryService());
        this.partitionStateGenerator = new PartitionStateGeneratorImpl();
    }

    @Probe(name="localPartitionCount")
    private int localPartitionCount() {
        int count = 0;
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isLocal()) continue;
            ++count;
        }
        return count;
    }

    @Probe(name="activePartitionCount")
    private int activePartitionCount() {
        return this.partitionService.getMemberPartitionsIfAssigned(this.node.getThisAddress()).size();
    }

    private Collection<MemberGroup> createMemberGroups(Set<Member> excludedMembers) {
        MemberSelector exclude = member -> !excludedMembers.contains(member);
        MemberSelector selector = MemberSelectors.and(MemberSelectors.DATA_MEMBER_SELECTOR, exclude);
        Collection<Member> members = this.node.getClusterService().getMembers(selector);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    private Collection<MemberGroup> createMemberGroups() {
        Collection<Member> members = this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    boolean initializePartitionAssignments(Set<Member> excludedMembers) {
        if (!this.isPartitionAssignmentAllowed()) {
            return false;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedMembers);
        if (memberGroups.isEmpty()) {
            this.logger.warning("No member group is available to assign partition ownership...");
            return false;
        }
        this.logger.info("Initializing cluster partition table arrangement...");
        PartitionReplica[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions);
        if (newState.length != this.partitionCount) {
            throw new HazelcastException("Invalid partition count! Expected: " + this.partitionCount + ", Actual: " + newState.length);
        }
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            PartitionReplica[] replicas = newState[partitionId];
            partition.setReplicas(replicas);
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            this.reset();
            this.logger.warning("Partitions can't be assigned since cluster-state= " + (Object)((Object)clusterState));
            return false;
        }
        this.setInitialized();
        return true;
    }

    private boolean isPartitionAssignmentAllowed() {
        if (!this.node.getNodeExtension().isStartCompleted()) {
            this.logger.warning("Partitions can't be assigned since startup is not completed yet.");
            return false;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            this.logger.warning("Partitions can't be assigned since cluster-state= " + (Object)((Object)clusterState));
            return false;
        }
        if (this.partitionService.isFetchMostRecentPartitionTableTaskRequired()) {
            this.logger.warning("Partitions can't be assigned since most recent partition table is not decided yet.");
            return false;
        }
        return true;
    }

    void setInitialState(PartitionTableView partitionTable) {
        if (this.initialized) {
            throw new IllegalStateException("Partition table is already initialized!");
        }
        this.logger.info("Setting cluster partition table...");
        boolean foundReplica = false;
        PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            InternalPartition newPartition = partitionTable.getPartition(partitionId);
            if (!foundReplica && newPartition != null) {
                for (int i = 0; i < 7; ++i) {
                    foundReplica |= newPartition.getReplica(i) != null;
                }
            }
            partition.reset(localReplica);
            if (newPartition == null) continue;
            partition.setReplicasAndVersion(newPartition);
        }
        this.stateVersion.set(partitionTable.version());
        if (foundReplica) {
            this.setInitialized();
        }
    }

    void updateMemberGroupsSize() {
        Collection<MemberGroup> groups = this.createMemberGroups();
        int size = 0;
        for (MemberGroup group : groups) {
            if (group.size() <= 0) continue;
            ++size;
        }
        this.memberGroupsSize = size;
    }

    int getMemberGroupsSize() {
        int size = this.memberGroupsSize;
        if (size > 0) {
            return size;
        }
        return this.node.isLiteMember() ? 0 : 1;
    }

    void removeUnknownMembers() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        for (InternalPartitionImpl partition : this.partitions) {
            for (int i = 0; i < 7; ++i) {
                PartitionReplica replica = partition.getReplica(i);
                if (replica == null || clusterService.getMember(replica.address(), replica.uuid()) != null) continue;
                partition.setReplica(i, null);
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("PartitionId=" + partition.getPartitionId() + " " + replica + " is removed from replica index: " + i + ", partition: " + partition);
            }
        }
    }

    boolean isAbsentInPartitionTable(Member member) {
        PartitionReplica replica = PartitionReplica.from(member);
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isOwnerOrBackup(replica)) continue;
            return false;
        }
        return true;
    }

    InternalPartition[] getPartitions() {
        return this.partitions;
    }

    public InternalPartition[] getPartitionsCopy(boolean readonly) {
        NopPartitionReplicaInterceptor interceptor = new NopPartitionReplicaInterceptor();
        InternalPartition[] result = new InternalPartition[this.partitions.length];
        for (int i = 0; i < this.partitionCount; ++i) {
            result[i] = readonly ? new ReadonlyInternalPartition(this.partitions[i]) : this.partitions[i].copy(interceptor);
        }
        return result;
    }

    public InternalPartitionImpl getPartitionImpl(int partitionId) {
        return this.partitions[partitionId];
    }

    PartitionReplica[][] repartition(Set<Member> excludedMembers, Collection<Integer> partitionInclusionSet) {
        if (!this.initialized) {
            return null;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedMembers);
        PartitionReplica[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions, partitionInclusionSet);
        if (newState == null && this.logger.isFinestEnabled()) {
            this.logger.finest("Partition rearrangement failed. Number of member groups: " + memberGroups.size());
        }
        return newState;
    }

    public boolean trySetMigratingFlag(int partitionId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Setting partition-migrating flag. partitionId=" + partitionId);
        }
        return this.partitions[partitionId].setMigrating();
    }

    public void clearMigratingFlag(int partitionId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Clearing partition-migrating flag. partitionId=" + partitionId);
        }
        this.partitions[partitionId].resetMigrating();
    }

    public boolean isMigrating(int partitionId) {
        return this.partitions[partitionId].isMigrating();
    }

    void updateReplicas(int partitionId, InternalPartition replicas) {
        InternalPartitionImpl partition = this.partitions[partitionId];
        partition.setReplicasAndVersion(replicas);
    }

    public void updateStamp() {
        this.stateStamp = PartitionStamp.calculateStamp(this.partitions);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("New partition state stamp is: " + this.stateStamp);
        }
    }

    public long getStamp() {
        return this.stateStamp;
    }

    public int getPartitionVersion(int partitionId) {
        return this.partitions[partitionId].version();
    }

    public void incrementPartitionVersion(int partitionId, int delta) {
        this.partitions[partitionId].incrementVersion(delta);
    }

    @Deprecated
    void setVersion(int version) {
        this.stateVersion.set(version);
    }

    @Deprecated
    public int getVersion() {
        return this.stateVersion.get();
    }

    @Deprecated
    void incrementVersion(int delta) {
        assert (delta > 0) : "Delta: " + delta;
        this.stateVersion.addAndGet(delta);
    }

    @Deprecated
    void incrementVersion() {
        this.stateVersion.incrementAndGet();
    }

    boolean setInitialized() {
        if (!this.initialized) {
            this.updateStamp();
            this.initialized = true;
            this.node.getNodeExtension().onPartitionStateChange();
            return true;
        }
        return false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void reset() {
        this.initialized = false;
        this.stateStamp = 0L;
        this.stateVersion.set(0);
        PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
        for (InternalPartitionImpl partition : this.partitions) {
            partition.reset(localReplica);
        }
    }

    int replaceMember(Member oldMember, Member newMember) {
        if (!this.initialized) {
            return 0;
        }
        PartitionReplica oldReplica = PartitionReplica.from(oldMember);
        PartitionReplica newReplica = PartitionReplica.from(newMember);
        int count = 0;
        for (InternalPartitionImpl partition : this.partitions) {
            if (partition.replaceReplica(oldReplica, newReplica) <= -1) continue;
            ++count;
        }
        if (count > 0) {
            this.node.getNodeExtension().onPartitionStateChange();
            this.logger.info("Replaced " + oldMember + " with " + newMember + " in partition table in " + count + " partitions.");
        }
        return count;
    }

    PartitionTableView getPartitionTable() {
        int version = 0;
        if (this.node.getClusterService().getClusterVersion().isUnknownOrLessOrEqual(Versions.V4_0)) {
            version = this.getVersion();
        }
        return new PartitionTableView(this.getPartitionsCopy(true), version);
    }

    @Override
    public void onClusterVersionChange(Version newVersion) {
        if (newVersion.isEqualTo(Versions.V4_1) && this.initialized) {
            int version = this.getVersion();
            for (InternalPartitionImpl partition : this.partitions) {
                partition.setVersion(version);
            }
            this.updateStamp();
        }
    }
}

