/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.ReplicaFragmentMigrationState;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.operation.BaseMigrationOperation;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MigrationOperation
extends BaseMigrationOperation
implements TargetAware {
    private static final OperationResponseHandler ERROR_RESPONSE_HANDLER = (op, obj) -> {
        throw new HazelcastException("Migration operations can not send response!");
    };
    private ReplicaFragmentMigrationState fragmentMigrationState;
    private boolean firstFragment;
    private boolean lastFragment;
    private Throwable failureReason;

    public MigrationOperation() {
    }

    public MigrationOperation(MigrationInfo migrationInfo, List<MigrationInfo> completedMigrations, int partitionStateVersion, ReplicaFragmentMigrationState fragmentMigrationState, boolean firstFragment, boolean lastFragment) {
        super(migrationInfo, completedMigrations, partitionStateVersion);
        this.fragmentMigrationState = fragmentMigrationState;
        this.firstFragment = firstFragment;
        this.lastFragment = lastFragment;
        this.setReplicaIndex(migrationInfo.getDestinationNewReplicaIndex());
    }

    @Override
    public void run() throws Exception {
        if (this.firstFragment) {
            this.setActiveMigration();
        }
        try {
            this.checkActiveMigration();
            this.doRun();
        }
        catch (Throwable t) {
            this.logMigrationFailure(t);
            this.failureReason = t;
        }
        finally {
            this.onMigrationComplete();
            if (!this.success) {
                this.onExecutionFailure(this.failureReason);
            }
        }
    }

    private void doRun() {
        try {
            if (this.firstFragment) {
                this.executeBeforeMigrations();
            }
            for (Operation migrationOperation : this.fragmentMigrationState.getMigrationOperations()) {
                this.runMigrationOperation(migrationOperation);
            }
            this.success = true;
        }
        catch (Throwable e) {
            this.failureReason = e;
            this.getLogger().severe("Error while executing replication operations " + this.migrationInfo, e);
        }
        finally {
            this.afterMigrate();
        }
    }

    private void checkActiveMigration() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        MigrationInfo activeMigration = partitionService.getMigrationManager().getActiveMigration(this.migrationInfo.getPartitionId());
        if (!this.migrationInfo.equals(activeMigration)) {
            throw new IllegalStateException("Unexpected active migration " + activeMigration + "! First migration fragment should have set active migration to: " + this.migrationInfo);
        }
    }

    private void runMigrationOperation(Operation op) throws Exception {
        this.prepareOperation(op);
        OperationRunner.runDirect(op);
    }

    protected void prepareOperation(Operation op) {
        op.setNodeEngine(this.getNodeEngine()).setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
        op.setOperationResponseHandler(ERROR_RESPONSE_HANDLER);
        OperationAccessor.setCallerAddress(op, this.migrationInfo.getSourceAddress());
    }

    private void afterMigrate() {
        ILogger logger = this.getLogger();
        if (this.success) {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            PartitionReplicaManager replicaManager = partitionService.getReplicaManager();
            int destinationNewReplicaIndex = this.migrationInfo.getDestinationNewReplicaIndex();
            int replicaOffset = Math.max(destinationNewReplicaIndex, 1);
            Map<ServiceNamespace, long[]> namespaceVersions = this.fragmentMigrationState.getNamespaceVersionMap();
            for (Map.Entry<ServiceNamespace, long[]> e : namespaceVersions.entrySet()) {
                ServiceNamespace namespace = e.getKey();
                long[] replicaVersions = e.getValue();
                replicaManager.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), namespace, replicaVersions, replicaOffset);
                if (!logger.isFinestEnabled()) continue;
                logger.finest("ReplicaVersions are set after migration. partitionId=" + this.migrationInfo.getPartitionId() + " namespace: " + namespace + " replicaVersions=" + Arrays.toString(replicaVersions));
            }
        } else if (logger.isFinestEnabled()) {
            logger.finest("ReplicaVersions are not set since migration failed. partitionId=" + this.migrationInfo.getPartitionId());
        }
    }

    private void logMigrationFailure(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof IllegalStateException) {
            logger.warning(e.getMessage());
        } else {
            logger.warning(e.getMessage(), e);
        }
    }

    @Override
    protected PartitionMigrationEvent getMigrationEvent() {
        return new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.migrationInfo.getPartitionId(), this.migrationInfo.getDestinationCurrentReplicaIndex(), this.migrationInfo.getDestinationNewReplicaIndex());
    }

    @Override
    protected MigrationInterceptor.MigrationParticipant getMigrationParticipantType() {
        return MigrationInterceptor.MigrationParticipant.DESTINATION;
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.fragmentMigrationState == null) {
            return;
        }
        Collection<Operation> tasks = this.fragmentMigrationState.getMigrationOperations();
        if (tasks != null) {
            for (Operation op : tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    void onMigrationStart() {
        if (this.firstFragment) {
            super.onMigrationStart();
        }
    }

    @Override
    void onMigrationComplete() {
        if (this.lastFragment) {
            super.onMigrationComplete();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.fragmentMigrationState);
        out.writeBoolean(this.firstFragment);
        out.writeBoolean(this.lastFragment);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fragmentMigrationState = (ReplicaFragmentMigrationState)in.readObject();
        this.firstFragment = in.readBoolean();
        this.lastFragment = in.readBoolean();
    }

    @Override
    public void setTarget(Address address) {
        this.fragmentMigrationState.setTarget(address);
    }
}

