/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.subscriber.DefaultQueryCacheRecordStore;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRecordStore;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.getters.Extractors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

abstract class AbstractInternalQueryCache<K, V>
implements InternalQueryCache<K, V> {
    protected final boolean includeValue;
    protected final String mapName;
    protected final String cacheId;
    protected final String cacheName;
    protected final IMap delegate;
    protected final Indexes indexes;
    protected final QueryCacheContext context;
    protected final QueryCacheConfig queryCacheConfig;
    protected final QueryCacheRecordStore recordStore;
    protected final PartitioningStrategy partitioningStrategy;
    protected final InternalSerializationService serializationService;
    protected final Extractors extractors;
    protected volatile UUID publisherListenerId;

    AbstractInternalQueryCache(String cacheId, String cacheName, QueryCacheConfig queryCacheConfig, IMap delegate, QueryCacheContext context) {
        this.cacheId = cacheId;
        this.cacheName = cacheName;
        this.queryCacheConfig = queryCacheConfig;
        this.mapName = delegate.getName();
        this.delegate = delegate;
        this.context = context;
        this.serializationService = context.getSerializationService();
        this.indexes = Indexes.newBuilder(this.serializationService, IndexCopyBehavior.COPY_ON_READ, queryCacheConfig.getInMemoryFormat()).build();
        this.includeValue = this.isIncludeValue();
        this.partitioningStrategy = this.getPartitioningStrategy();
        this.extractors = Extractors.newBuilder(this.serializationService).build();
        this.recordStore = new DefaultQueryCacheRecordStore(this.serializationService, this.indexes, queryCacheConfig, this.getEvictionListener(), this.extractors);
        assert (this.indexes.isGlobal());
        for (IndexConfig indexConfig : queryCacheConfig.getIndexConfigs()) {
            IndexConfig indexConfig0 = this.getNormalizedIndexConfig(indexConfig);
            this.indexes.addOrGetIndex(indexConfig0, null);
        }
    }

    public QueryCacheContext getContext() {
        return this.context;
    }

    @Override
    public UUID getPublisherListenerId() {
        return this.publisherListenerId;
    }

    @Override
    public void setPublisherListenerId(UUID publisherListenerId) {
        this.publisherListenerId = Objects.requireNonNull(publisherListenerId, "publisherListenerId cannot be null");
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    protected Predicate getPredicate() {
        return this.queryCacheConfig.getPredicateConfig().getImplementation();
    }

    @Override
    public boolean reachedMaxCapacity() {
        EvictionConfig evictionConfig = this.queryCacheConfig.getEvictionConfig();
        MaxSizePolicy maximumSizePolicy = evictionConfig.getMaxSizePolicy();
        return maximumSizePolicy == MaxSizePolicy.ENTRY_COUNT && this.size() == evictionConfig.getSize();
    }

    private EvictionListener getEvictionListener() {
        return (dataKey, record, wasExpired) -> EventPublisherHelper.publishEntryEvent(this.context, this.mapName, this.cacheId, dataKey, null, record, EntryEventType.EVICTED, this.extractors);
    }

    PartitioningStrategy getPartitioningStrategy() {
        if (this.delegate instanceof MapProxyImpl) {
            return ((MapProxyImpl)this.delegate).getPartitionStrategy();
        }
        return null;
    }

    protected void doFullKeyScan(Predicate predicate, Set<K> resultingSet) {
        InternalSerializationService serializationService = this.serializationService;
        CachedQueryEntry queryEntry = new CachedQueryEntry();
        Set<Map.Entry<Data, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Data, QueryCacheRecord> entry : entries) {
            Data keyData = entry.getKey();
            QueryCacheRecord record = entry.getValue();
            Object value = record.getValue();
            queryEntry.init(serializationService, keyData, value, this.extractors);
            boolean valid = predicate.apply(queryEntry);
            if (!valid) continue;
            resultingSet.add(queryEntry.getKey());
        }
    }

    protected void doFullEntryScan(Predicate predicate, Set<Map.Entry<K, V>> resultingSet) {
        InternalSerializationService serializationService = this.serializationService;
        CachedQueryEntry queryEntry = new CachedQueryEntry();
        Set<Map.Entry<Data, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Data, QueryCacheRecord> entry : entries) {
            Data keyData = entry.getKey();
            QueryCacheRecord record = entry.getValue();
            Object value = record.getValue();
            queryEntry.init(serializationService, keyData, value, this.extractors);
            boolean valid = predicate.apply(queryEntry);
            if (!valid) continue;
            LazyMapEntry simpleEntry = new LazyMapEntry(queryEntry.getKeyData(), queryEntry.getValueData(), serializationService);
            resultingSet.add(simpleEntry);
        }
    }

    protected void doFullValueScan(Predicate predicate, List<Data> resultingSet) {
        InternalSerializationService serializationService = this.serializationService;
        CachedQueryEntry queryEntry = new CachedQueryEntry();
        Set<Map.Entry<Data, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Data, QueryCacheRecord> entry : entries) {
            Data keyData = entry.getKey();
            QueryCacheRecord record = entry.getValue();
            Object value = record.getValue();
            queryEntry.init(serializationService, keyData, value, this.extractors);
            boolean valid = predicate.apply(queryEntry);
            if (!valid) continue;
            resultingSet.add(queryEntry.getValueData());
        }
    }

    private boolean isIncludeValue() {
        return this.queryCacheConfig.isIncludeValue();
    }

    protected QueryCacheEventService getEventService() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        return subscriberContext.getEventService();
    }

    protected <T> T toObject(Object valueInRecord) {
        return this.serializationService.toObject(valueInRecord);
    }

    protected Data toData(Object key) {
        return this.serializationService.toData(key, this.partitioningStrategy);
    }

    @Override
    public Extractors getExtractors() {
        return this.extractors;
    }

    @Override
    public void clear() {
        this.indexes.destroyIndexes();
        this.recordStore.clear();
    }

    protected IndexConfig getNormalizedIndexConfig(IndexConfig originalConfig) {
        String name = this.delegate.getName() + "_" + this.cacheName;
        return IndexUtils.validateAndNormalize(name, originalConfig);
    }
}

