/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.tx.MapTxnOperation;
import com.hazelcast.map.impl.tx.TxnDeleteBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnDeleteOperation
extends BaseRemoveOperation
implements MapTxnOperation {
    private long version;
    private UUID ownerUuid;
    private UUID transactionId;
    private transient boolean successful;

    public TxnDeleteOperation() {
    }

    public TxnDeleteOperation(String name, Data dataKey, long version) {
        super(name, dataKey);
        this.version = version;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (!this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.threadId)) {
            this.wbqCapacityCounter().decrement(this.transactionId);
            throw new TransactionException("Cannot acquire lock UUID: " + this.ownerUuid + ", threadId: " + this.threadId);
        }
    }

    @Override
    protected void runInternal() {
        this.recordStore.unlock(this.dataKey, this.ownerUuid, this.getThreadId(), this.getCallId());
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record == null || this.version == record.getVersion()) {
            this.dataOldValue = this.getNodeEngine().toData(this.recordStore.removeTxn(this.dataKey, this.getCallerProvenance(), this.transactionId));
            boolean bl = this.successful = this.dataOldValue != null;
        }
        if (record == null) {
            this.wbqCapacityCounter().decrement(this.transactionId);
        }
    }

    @Override
    public boolean shouldWait() {
        return false;
    }

    @Override
    protected void afterRunInternal() {
        if (this.successful) {
            super.afterRunInternal();
        }
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(false);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnDeleteBackupOperation(this.name, this.dataKey, this.transactionId);
    }

    @Override
    public void setOwnerUuid(UUID ownerUuid) {
        this.ownerUuid = ownerUuid;
    }

    @Override
    public void setTransactionId(UUID transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.version);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readLong();
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 64;
    }
}

