/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CompositeValue;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import com.hazelcast.query.impl.TypeConverters;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public abstract class BaseIndexStore
implements IndexStore {
    static final float LOAD_FACTOR = 0.75f;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final CopyFunctor<Data, QueryableEntry> resultCopyFunctor;
    private volatile boolean isIndexStoreExpirable;

    BaseIndexStore(IndexCopyBehavior copyOn, boolean enableGlobalLock) {
        this.resultCopyFunctor = copyOn == IndexCopyBehavior.COPY_ON_WRITE || copyOn == IndexCopyBehavior.NEVER ? new PassThroughFunctor() : new CopyInputFunctor();
        this.lock = enableGlobalLock ? new ReentrantReadWriteLock() : null;
        this.readLock = enableGlobalLock ? this.lock.readLock() : null;
        this.writeLock = enableGlobalLock ? this.lock.writeLock() : null;
    }

    abstract Comparable canonicalizeScalarForStorage(Comparable var1);

    void takeWriteLock() {
        if (this.lock != null) {
            this.writeLock.lock();
        }
    }

    void releaseWriteLock() {
        if (this.lock != null) {
            this.writeLock.unlock();
        }
    }

    void takeReadLock() {
        if (this.lock != null) {
            this.readLock.lock();
        }
    }

    void releaseReadLock() {
        if (this.lock != null) {
            this.readLock.unlock();
        }
    }

    final void copyToMultiResultSet(MultiResultSet resultSet, Map<Data, QueryableEntry> records) {
        resultSet.addResultSet(this.resultCopyFunctor.invoke(records));
    }

    final Set<QueryableEntry> toSingleResultSet(Map<Data, QueryableEntry> records) {
        return new SingleResultSet(this.resultCopyFunctor.invoke(records));
    }

    @Override
    public void destroy() {
    }

    Comparable sanitizeValue(Object input) {
        if (input instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)input;
            Comparable[] components = compositeValue.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i] = this.sanitizeScalar(components[i]);
            }
            return compositeValue;
        }
        return this.sanitizeScalar(input);
    }

    private Comparable sanitizeScalar(Object input) {
        if (input == null || input instanceof Comparable) {
            Comparable value = (Comparable)input;
            if (value == null) {
                value = AbstractIndex.NULL;
            } else if (value.getClass().isEnum()) {
                value = TypeConverters.ENUM_CONVERTER.convert(value);
            }
            return this.canonicalizeScalarForStorage(value);
        }
        throw new IllegalArgumentException("It is not allowed to use a type that is not Comparable: " + input.getClass());
    }

    void markIndexStoreExpirableIfNecessary(QueryableEntry record) {
        if (record.getStoreAdapter() != null) {
            this.isIndexStoreExpirable = record.getStoreAdapter().isExpirable();
        }
    }

    boolean isExpirable() {
        return this.isIndexStoreExpirable;
    }

    protected static final class ExpirationAwareHashMapDelegate
    implements Map<Data, QueryableEntry> {
        private final Map<Data, QueryableEntry> delegateMap;

        ExpirationAwareHashMapDelegate(Map<Data, QueryableEntry> map) {
            this.delegateMap = map;
        }

        @Override
        public int size() {
            return this.delegateMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegateMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.delegateMap.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.delegateMap.containsValue(o);
        }

        @Override
        public QueryableEntry put(Data data, QueryableEntry queryableEntry) {
            return this.delegateMap.put(data, queryableEntry);
        }

        @Override
        public QueryableEntry remove(Object o) {
            return this.delegateMap.remove(o);
        }

        @Override
        public void putAll(Map<? extends Data, ? extends QueryableEntry> map) {
            this.delegateMap.putAll(map);
        }

        @Override
        public void clear() {
            this.delegateMap.clear();
        }

        @Override
        public Set<Data> keySet() {
            return this.delegateMap.keySet();
        }

        @Override
        public QueryableEntry get(Object o) {
            QueryableEntry queryableEntry = this.delegateMap.get(o);
            if (queryableEntry != null) {
                long now = Clock.currentTimeMillis();
                queryableEntry.getRecord().onAccessSafe(now);
            }
            return queryableEntry;
        }

        @Override
        public Collection<QueryableEntry> values() {
            long now = Clock.currentTimeMillis();
            return new ExpirationAwareSet<QueryableEntry>(this.delegateMap.values(), queryableEntry -> queryableEntry.getRecord().onAccessSafe(now));
        }

        @Override
        public Set<Map.Entry<Data, QueryableEntry>> entrySet() {
            long now = Clock.currentTimeMillis();
            return new ExpirationAwareSet<Map.Entry<Data, QueryableEntry>>(this.delegateMap.entrySet(), entry -> ((QueryableEntry)entry.getValue()).getRecord().onAccessSafe(now));
        }

        private static class ExpirationAwareSet<V>
        extends AbstractSet<V> {
            private final Collection<V> delegateCollection;
            private final Consumer<V> recordUpdater;

            ExpirationAwareSet(Collection<V> delegateCollection, Consumer<V> recordUpdater) {
                this.delegateCollection = delegateCollection;
                this.recordUpdater = recordUpdater;
            }

            @Override
            public int size() {
                return this.delegateCollection.size();
            }

            @Override
            public Iterator<V> iterator() {
                return new ExpirationAwareIterator(this.delegateCollection.iterator());
            }

            @Override
            public boolean add(V v) {
                return this.delegateCollection.add(v);
            }

            @Override
            public boolean remove(Object o) {
                return this.delegateCollection.remove(o);
            }

            @Override
            public void clear() {
                this.delegateCollection.clear();
            }

            private class ExpirationAwareIterator
            implements Iterator<V> {
                private final Iterator<V> delegateIterator;

                ExpirationAwareIterator(Iterator<V> iterator) {
                    this.delegateIterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public V next() {
                    Object next = this.delegateIterator.next();
                    if (next != null) {
                        ExpirationAwareSet.this.recordUpdater.accept(next);
                    }
                    return next;
                }

                @Override
                public void remove() {
                    this.delegateIterator.remove();
                }
            }
        }
    }

    private class CopyInputFunctor
    implements CopyFunctor<Data, QueryableEntry> {
        private CopyInputFunctor() {
        }

        @Override
        public Map<Data, QueryableEntry> invoke(Map<Data, QueryableEntry> map) {
            if (map != null && !map.isEmpty()) {
                HashMap<Data, QueryableEntry> newMap = new HashMap<Data, QueryableEntry>(map);
                if (BaseIndexStore.this.isExpirable()) {
                    return new ExpirationAwareHashMapDelegate(newMap);
                }
                return newMap;
            }
            return map;
        }
    }

    private class PassThroughFunctor
    implements CopyFunctor<Data, QueryableEntry> {
        private PassThroughFunctor() {
        }

        @Override
        public Map<Data, QueryableEntry> invoke(Map<Data, QueryableEntry> map) {
            if (map != null && BaseIndexStore.this.isExpirable()) {
                return new ExpirationAwareHashMapDelegate(map);
            }
            return map;
        }
    }

    static interface IndexFunctor<A, B> {
        public Object invoke(A var1, B var2);
    }

    static interface CopyFunctor<A, B> {
        public Map<A, B> invoke(Map<A, B> var1);
    }
}

