/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import java.util.Collection;
import java.util.UUID;

public final class QueryException
extends HazelcastException {
    private final int code;
    private final UUID originatingMemberId;
    private final boolean invalidatePlan;

    private QueryException(int code, String message, Throwable cause, UUID originatingMemberId) {
        this(code, message, cause, originatingMemberId, false);
    }

    private QueryException(int code, String message, Throwable cause, UUID originatingMemberId, boolean invalidatePlan) {
        super(message, cause);
        this.code = code;
        this.originatingMemberId = originatingMemberId;
        this.invalidatePlan = invalidatePlan;
    }

    public static QueryException error(String message) {
        return QueryException.error(message, null);
    }

    public static QueryException error(String message, Throwable cause) {
        return QueryException.error(-1, message, cause, null);
    }

    public static QueryException error(int code, String message) {
        return new QueryException(code, message, null, null);
    }

    public static QueryException error(int code, String message, Throwable cause) {
        return new QueryException(code, message, cause, null);
    }

    public static QueryException error(int code, String message, UUID originatingMemberId) {
        return new QueryException(code, message, null, originatingMemberId);
    }

    public static QueryException error(int code, String message, Throwable cause, UUID originatingMemberId) {
        return new QueryException(code, message, cause, originatingMemberId);
    }

    public static QueryException memberConnection(UUID memberId) {
        return QueryException.error(1001, "Member cannot be reached: " + memberId).withInvalidate();
    }

    public static QueryException memberConnection(Address address) {
        return QueryException.error(1001, "Member cannot be reached: " + address).withInvalidate();
    }

    public static QueryException memberConnection(Collection<UUID> memberIds) {
        return QueryException.error(1001, "Members cannot be reached: " + memberIds).withInvalidate();
    }

    public static QueryException clientMemberConnection(UUID clientId) {
        return QueryException.error(1001, "Client cannot be reached: " + clientId);
    }

    public static QueryException timeout(long timeout) {
        return QueryException.error(1004, "Query has been cancelled due to a timeout (" + timeout + " ms)");
    }

    public static QueryException cancelledByUser() {
        return QueryException.error(1003, "Query was cancelled by the user");
    }

    public static QueryException dataException(String message, Throwable cause) {
        return QueryException.error(2000, message, cause);
    }

    public static QueryException dataException(String message) {
        return QueryException.dataException(message, null);
    }

    public QueryException withInvalidate() {
        return new QueryException(this.code, this.getMessage(), this.getCause(), this.originatingMemberId, true);
    }

    public int getCode() {
        return this.code;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    public boolean isInvalidatePlan() {
        return this.invalidatePlan;
    }
}

