/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControlFactory;
import com.hazelcast.sql.impl.exec.io.flowcontrol.simple.SimpleFlowControlFactory;
import com.hazelcast.sql.impl.exec.root.BlockingRootResultConsumer;
import com.hazelcast.sql.impl.operation.QueryExecuteOperation;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFactory;
import com.hazelcast.sql.impl.operation.QueryOperationHandlerImpl;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import com.hazelcast.sql.impl.state.QueryState;
import com.hazelcast.sql.impl.state.QueryStateRegistry;
import com.hazelcast.sql.impl.state.QueryStateRegistryUpdater;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SqlInternalService {
    public static final String SERVICE_NAME = "hz:impl:sqlService";
    private static final long MEMORY_PER_EDGE_MAILBOX = 524288L;
    private static final FlowControlFactory FLOW_CONTROL_FACTORY = SimpleFlowControlFactory.INSTANCE;
    private final NodeServiceProvider nodeServiceProvider;
    private final QueryStateRegistry stateRegistry;
    private final QueryClientStateRegistry clientStateRegistry;
    private final QueryOperationHandlerImpl operationHandler;
    private final QueryStateRegistryUpdater stateRegistryUpdater;

    public SqlInternalService(String instanceName, NodeServiceProvider nodeServiceProvider, InternalSerializationService serializationService, int operationThreadCount, int fragmentThreadCount, int outboxBatchSize, long stateCheckFrequency, PlanCacheChecker planCacheChecker) {
        this.nodeServiceProvider = nodeServiceProvider;
        this.stateRegistry = new QueryStateRegistry(nodeServiceProvider);
        this.clientStateRegistry = new QueryClientStateRegistry();
        this.operationHandler = new QueryOperationHandlerImpl(instanceName, nodeServiceProvider, serializationService, this.stateRegistry, outboxBatchSize, FLOW_CONTROL_FACTORY, fragmentThreadCount, operationThreadCount);
        this.stateRegistryUpdater = new QueryStateRegistryUpdater(instanceName, nodeServiceProvider, this.stateRegistry, this.clientStateRegistry, this.operationHandler, planCacheChecker, stateCheckFrequency);
    }

    public void start() {
        this.stateRegistryUpdater.start();
    }

    public void reset() {
        this.stateRegistry.reset();
        this.clientStateRegistry.reset();
    }

    public void shutdown() {
        this.stateRegistryUpdater.stop();
        this.operationHandler.stop();
        this.reset();
    }

    public QueryState execute(Plan plan, List<Object> params, long timeout, int pageSize, CachedPlanInvalidationCallback planInvalidationCallback) {
        this.prepareParameters(plan, params);
        UUID localMemberId = this.nodeServiceProvider.getLocalMemberId();
        if (!plan.getPartitionMap().containsKey(localMemberId)) {
            throw QueryException.memberConnection(localMemberId);
        }
        QueryExecuteOperationFactory operationFactory = new QueryExecuteOperationFactory(plan, params, this.createEdgeInitialMemoryMapForPlan(plan));
        BlockingRootResultConsumer consumer = new BlockingRootResultConsumer();
        QueryState state = this.stateRegistry.onInitiatorQueryStarted(localMemberId, timeout, plan, planInvalidationCallback, plan.getRowMetadata(), consumer, this.operationHandler);
        try {
            QueryExecuteOperation localOp = operationFactory.create(state.getQueryId(), localMemberId);
            localOp.setRootConsumer(consumer, pageSize);
            this.operationHandler.submitLocal(localMemberId, localOp);
            for (UUID memberId : plan.getMemberIds()) {
                QueryExecuteOperation remoteOp;
                if (memberId.equals(localMemberId) || this.operationHandler.submit(localMemberId, memberId, remoteOp = operationFactory.create(state.getQueryId(), memberId))) continue;
                throw QueryException.memberConnection(memberId);
            }
            return state;
        }
        catch (Exception e) {
            state.cancel(e);
            throw e;
        }
    }

    public void onPacket(Packet packet) {
        this.operationHandler.onPacket(packet);
    }

    private Map<Integer, Long> createEdgeInitialMemoryMapForPlan(Plan plan) {
        Map<Integer, Integer> inboundEdgeMemberCountMap = plan.getInboundEdgeMemberCountMap();
        HashMap<Integer, Long> res = new HashMap<Integer, Long>(inboundEdgeMemberCountMap.size());
        for (Map.Entry<Integer, Integer> entry : inboundEdgeMemberCountMap.entrySet()) {
            res.put(entry.getKey(), 524288L);
        }
        return res;
    }

    public QueryStateRegistry getStateRegistry() {
        return this.stateRegistry;
    }

    public QueryOperationHandlerImpl getOperationHandler() {
        return this.operationHandler;
    }

    public QueryClientStateRegistry getClientStateRegistry() {
        return this.clientStateRegistry;
    }

    private void prepareParameters(Plan plan, List<Object> params) {
        assert (params != null);
        QueryParameterMetadata parameterMetadata = plan.getParameterMetadata();
        int parameterCount = parameterMetadata.getParameterCount();
        if (parameterCount != params.size()) {
            throw QueryException.error(2000, "Unexpected parameter count: expected " + parameterCount + ", got " + params.size());
        }
        for (int i = 0; i < params.size(); ++i) {
            Object value = params.get(i);
            if (value == null) continue;
            Converter fromConverter = Converters.getConverter(value.getClass());
            Converter toConverter = parameterMetadata.getParameterType(i).getConverter();
            if (fromConverter.getTypeFamily().getPrecedence() > toConverter.getTypeFamily().getPrecedence()) {
                throw QueryException.error(2000, "Cannot implicitly convert parameter at position " + i + " from " + (Object)((Object)fromConverter.getTypeFamily()) + " to " + (Object)((Object)toConverter.getTypeFamily()) + " (consider adding an explicit CAST)");
            }
            try {
                value = toConverter.convertToSelf(fromConverter, value);
            }
            catch (RuntimeException e) {
                throw QueryException.error(2000, String.format("Failed to convert parameter at position %s from %s to %s: %s", new Object[]{i, fromConverter.getTypeFamily(), toConverter.getTypeFamily(), e.getMessage()}));
            }
            params.set(i, value);
        }
    }
}

