/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.jdbc.HazelcastRootCalciteSchema;
import com.hazelcast.org.apache.calcite.plan.Contexts;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.tools.RuleSet;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.HazelcastRexBuilder;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.opt.QueryPlanner;
import com.hazelcast.sql.impl.calcite.opt.cost.CostFactory;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTraitDef;
import com.hazelcast.sql.impl.calcite.opt.metadata.HazelcastRelMdRowCount;
import com.hazelcast.sql.impl.calcite.parse.CasingConfiguration;
import com.hazelcast.sql.impl.calcite.parse.QueryConvertResult;
import com.hazelcast.sql.impl.calcite.parse.QueryConverter;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.parse.QueryParser;
import com.hazelcast.sql.impl.calcite.schema.HazelcastCalciteCatalogReader;
import com.hazelcast.sql.impl.calcite.schema.HazelcastSchema;
import com.hazelcast.sql.impl.calcite.schema.HazelcastSchemaUtils;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlConformance;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class OptimizerContext {
    private static final RelMetadataProvider METADATA_PROVIDER = ChainedRelMetadataProvider.of(ImmutableList.of(HazelcastRelMdRowCount.SOURCE, DefaultRelMetadataProvider.INSTANCE));
    private static final CalciteConnectionConfig CONNECTION_CONFIG = CasingConfiguration.DEFAULT.toConnectionConfig();
    private final HazelcastRelOptCluster cluster;
    private final QueryParser parser;
    private final QueryConverter converter;
    private final QueryPlanner planner;

    private OptimizerContext(HazelcastRelOptCluster cluster, QueryParser parser, QueryConverter converter, QueryPlanner planner) {
        this.cluster = cluster;
        this.parser = parser;
        this.converter = converter;
        this.planner = planner;
    }

    public static OptimizerContext create(SqlCatalog schema, List<List<String>> searchPaths, int memberCount, @Nonnull SqlBackend sqlBackend, @Nullable SqlBackend jetSqlBackend) {
        HazelcastSchema rootSchema = HazelcastSchemaUtils.createRootSchema(schema);
        return OptimizerContext.create(rootSchema, searchPaths, memberCount, sqlBackend, jetSqlBackend);
    }

    public static OptimizerContext create(HazelcastSchema rootSchema, List<List<String>> schemaPaths, int memberCount, @Nonnull SqlBackend sqlBackend, @Nullable SqlBackend jetSqlBackend) {
        DistributionTraitDef distributionTraitDef = new DistributionTraitDef(memberCount);
        HazelcastSqlConformance conformance = HazelcastSqlConformance.INSTANCE;
        HazelcastTypeFactory typeFactory = HazelcastTypeFactory.INSTANCE;
        Prepare.CatalogReader catalogReader = OptimizerContext.createCatalogReader(typeFactory, CONNECTION_CONFIG, rootSchema, schemaPaths);
        VolcanoPlanner volcanoPlanner = OptimizerContext.createPlanner(CONNECTION_CONFIG, distributionTraitDef);
        HazelcastRelOptCluster cluster = OptimizerContext.createCluster(volcanoPlanner, typeFactory, distributionTraitDef);
        QueryParser parser = new QueryParser(typeFactory, catalogReader, conformance, sqlBackend, jetSqlBackend);
        QueryConverter converter = new QueryConverter(catalogReader, cluster);
        QueryPlanner planner = new QueryPlanner(volcanoPlanner);
        return new OptimizerContext(cluster, parser, converter, planner);
    }

    public QueryParseResult parse(String sql) {
        return this.parser.parse(sql);
    }

    public QueryConvertResult convert(QueryParseResult parseResult) {
        return this.converter.convert(parseResult);
    }

    public void setParameterMetadata(QueryParameterMetadata parameterMetadata) {
        this.cluster.setParameterMetadata(parameterMetadata);
    }

    public RelNode optimize(RelNode node, RuleSet rules, RelTraitSet traitSet) {
        return this.planner.optimize(node, rules, traitSet);
    }

    private static Prepare.CatalogReader createCatalogReader(HazelcastTypeFactory typeFactory, CalciteConnectionConfig config, HazelcastSchema rootSchema, List<List<String>> searchPaths) {
        assert (searchPaths != null);
        return new HazelcastCalciteCatalogReader((CalciteSchema)new HazelcastRootCalciteSchema(rootSchema), searchPaths, (RelDataTypeFactory)typeFactory, config);
    }

    private static VolcanoPlanner createPlanner(CalciteConnectionConfig config, DistributionTraitDef distributionTraitDef) {
        VolcanoPlanner planner = new VolcanoPlanner(CostFactory.INSTANCE, Contexts.of((Object)config));
        planner.clearRelTraitDefs();
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef(distributionTraitDef);
        return planner;
    }

    private static HazelcastRelOptCluster createCluster(VolcanoPlanner planner, HazelcastTypeFactory typeFactory, DistributionTraitDef distributionTraitDef) {
        HazelcastRelOptCluster cluster = HazelcastRelOptCluster.create(planner, new HazelcastRexBuilder(typeFactory), distributionTraitDef);
        cluster.setMetadataProvider(JaninoRelMetadataProvider.of(METADATA_PROVIDER));
        return cluster;
    }
}

