/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.parse;

import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.parse.CasingConfiguration;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlConformance;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueryParser {
    private final HazelcastTypeFactory typeFactory;
    private final Prepare.CatalogReader catalogReader;
    private final SqlConformance conformance;
    private final SqlBackend sqlBackend;
    private final SqlBackend jetSqlBackend;

    public QueryParser(HazelcastTypeFactory typeFactory, Prepare.CatalogReader catalogReader, SqlConformance conformance, @Nonnull SqlBackend sqlBackend, @Nullable SqlBackend jetSqlBackend) {
        this.typeFactory = typeFactory;
        this.catalogReader = catalogReader;
        this.conformance = conformance;
        this.sqlBackend = sqlBackend;
        this.jetSqlBackend = jetSqlBackend;
    }

    public QueryParseResult parse(String sql) {
        try {
            return this.parse(sql, this.sqlBackend);
        }
        catch (Exception e) {
            try {
                if (this.jetSqlBackend != null) {
                    return this.parse(sql, this.jetSqlBackend);
                }
                throw e;
            }
            catch (Exception e2) {
                throw QueryException.error(1008, e2.getMessage(), e2);
            }
        }
    }

    private QueryParseResult parse(String sql, SqlBackend sqlBackend) throws SqlParseException {
        assert (sqlBackend != null);
        SqlParser.Config config = QueryParser.createConfig(sqlBackend.parserFactory());
        SqlParser parser = SqlParser.create(sql, config);
        SqlValidator validator = sqlBackend.validator(this.catalogReader, this.typeFactory, this.conformance);
        SqlNode node = validator.validate(parser.parseStmt());
        SqlVisitor<Void> visitor = sqlBackend.unsupportedOperationVisitor(this.catalogReader);
        node.accept(visitor);
        return new QueryParseResult(node, validator.getParameterRowType(node), validator, sqlBackend);
    }

    private static SqlParser.Config createConfig(SqlParserImplFactory parserImplFactory) {
        SqlParser.ConfigBuilder configBuilder = SqlParser.configBuilder();
        CasingConfiguration.DEFAULT.toParserConfig(configBuilder);
        configBuilder.setConformance(HazelcastSqlConformance.INSTANCE);
        if (parserImplFactory != null) {
            configBuilder.setParserFactory(parserImplFactory);
        }
        return configBuilder.build();
    }
}

