/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlCloseCodec;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlPage;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;

public class SqlClientService
implements SqlService {
    private static final int SERVICE_ID_MASK = 0xFF0000;
    private static final int SERVICE_ID_SHIFT = 16;
    private static final int METHOD_ID_MASK = 65280;
    private static final int METHOD_ID_SHIFT = 8;
    private static final int SQL_SERVICE_ID = 33;
    private static final int INVALID_MESSAGE_ID = 255;
    private final HazelcastClientInstanceImpl client;

    public SqlClientService(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement statement) {
        ClientConnection connection = this.client.getConnectionManager().getRandomConnection(true);
        if (connection == null) {
            throw this.rethrow(QueryException.error(1001, "Client must be connected to at least one data member to execute SQL queries"));
        }
        try {
            List<Object> params = statement.getParameters();
            ArrayList<Data> params0 = new ArrayList<Data>(params.size());
            for (Object param : params) {
                params0.add(this.serializeParameter(param));
            }
            ClientMessage requestMessage = SqlExecuteCodec.encodeRequest(statement.getSql(), params0, statement.getTimeoutMillis(), statement.getCursorBufferSize());
            ClientMessage responseMessage = this.invoke(requestMessage, connection);
            SqlExecuteCodec.ResponseParameters response = SqlExecuteCodec.decodeResponse(responseMessage);
            SqlClientService.handleResponseError(response.error);
            return new SqlClientResult(response.isUpdateCount, this, connection, response.queryId, response.rowMetadata != null ? new SqlRowMetadata(response.rowMetadata) : null, response.rowPage, response.rowPageLast, statement.getCursorBufferSize(), response.updatedCount);
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    public SqlPage fetch(Connection connection, QueryId queryId, int cursorBufferSize) {
        try {
            ClientMessage requestMessage = SqlFetchCodec.encodeRequest(queryId, cursorBufferSize);
            ClientMessage responseMessage = this.invoke(requestMessage, connection);
            SqlFetchCodec.ResponseParameters responseParameters = SqlFetchCodec.decodeResponse(responseMessage);
            SqlClientService.handleResponseError(responseParameters.error);
            return new SqlPage(responseParameters.rowPage, responseParameters.rowPageLast);
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    void close(Connection connection, QueryId queryId) {
        try {
            ClientMessage requestMessage = SqlCloseCodec.encodeRequest(queryId);
            this.invoke(requestMessage, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e, connection);
        }
    }

    public void missing() {
        ClientConnection connection = this.client.getConnectionManager().getRandomConnection(false);
        if (connection == null) {
            throw this.rethrow(QueryException.error(1001, "Client is not connected to topology"));
        }
        try {
            ClientMessage requestMessage = SqlCloseCodec.encodeRequest(QueryId.create(UuidUtil.newSecureUUID()));
            int messageType = requestMessage.getMessageType();
            int messageTypeWithInvalidMethodId = messageType & 0xFFFF00FF | 0xFF00;
            requestMessage.setMessageType(messageTypeWithInvalidMethodId);
            this.invoke(requestMessage, connection);
        }
        catch (Exception e) {
            throw this.rethrow(e);
        }
    }

    private Data serializeParameter(Object parameter) {
        try {
            return this.getSerializationService().toData(parameter);
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to serialize query parameter " + parameter + ": " + e.getMessage()));
        }
    }

    Object deserializeRowValue(Data data) {
        try {
            return this.getSerializationService().toObject(data);
        }
        catch (Exception e) {
            throw this.rethrow(QueryException.error("Failed to deserialize query result value: " + e.getMessage()));
        }
    }

    private UUID getClientId() {
        return this.client.getLocalEndpoint().getUuid();
    }

    private InternalSerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    private ClientMessage invoke(ClientMessage request, Connection connection) throws Exception {
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, connection);
        ClientInvocationFuture fut = invocation.invoke();
        return (ClientMessage)fut.get();
    }

    private static void handleResponseError(SqlError error) {
        if (error != null) {
            throw new HazelcastSqlException(error.getOriginatingMemberId(), error.getCode(), error.getMessage(), null);
        }
    }

    private RuntimeException rethrow(Exception cause, Connection connection) {
        if (!connection.isAlive()) {
            return QueryUtils.toPublicException(QueryException.memberConnection(connection.getRemoteAddress()), this.getClientId());
        }
        return this.rethrow(cause);
    }

    RuntimeException rethrow(Exception cause) {
        if (cause.getCause() instanceof AccessControlException) {
            return (AccessControlException)cause.getCause();
        }
        throw QueryUtils.toPublicException(cause, this.getClientId());
    }

    public static boolean isSqlMessage(int messageType) {
        int serviceId = (messageType & 0xFF0000) >> 16;
        return serviceId == 33;
    }
}

