/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlCloseCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import java.security.Permission;

public class SqlCloseMessageTask
extends SqlAbstractMessageTask<QueryId> {
    public SqlCloseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        SqlInternalService service = this.nodeEngine.getSqlService().getInternalService();
        service.getClientStateRegistry().close(this.endpoint.getUuid(), (QueryId)this.parameters);
        return null;
    }

    @Override
    protected QueryId decodeClientMessage(ClientMessage clientMessage) {
        return SqlCloseCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return SqlCloseCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:sqlService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "close";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public Permission getRequiredPermission() {
        return new SqlPermission();
    }
}

