/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import com.hazelcast.sql.impl.client.SqlClientUtils;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlExecuteResponse;
import com.hazelcast.sql.impl.client.SqlPage;
import java.security.Permission;
import java.util.Collection;
import java.util.List;

public class SqlExecuteMessageTask
extends SqlAbstractMessageTask<SqlExecuteCodec.RequestParameters> {
    public SqlExecuteMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        try {
            SqlStatement query = new SqlStatement(((SqlExecuteCodec.RequestParameters)this.parameters).sql);
            for (Data param : ((SqlExecuteCodec.RequestParameters)this.parameters).parameters) {
                query.addParameter(this.serializationService.toObject(param));
            }
            query.setTimeoutMillis(((SqlExecuteCodec.RequestParameters)this.parameters).timeoutMillis);
            query.setCursorBufferSize(((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize);
            SqlServiceImpl sqlService = this.nodeEngine.getSqlService();
            AbstractSqlResult result = (AbstractSqlResult)sqlService.execute(query);
            if (result.isUpdateCount()) {
                return SqlExecuteResponse.updateCountResponse(result.updateCount());
            }
            SqlPage page = sqlService.getInternalService().getClientStateRegistry().registerAndFetch(this.endpoint.getUuid(), result, ((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize, this.serializationService);
            return SqlExecuteResponse.rowsResponse(result.getQueryId(), result.getRowMetadata().getColumns(), page.getRows(), page.isLast());
        }
        catch (Exception e) {
            SqlError error = SqlClientUtils.exceptionToClientError(e, this.nodeEngine.getLocalMember().getUuid());
            return SqlExecuteResponse.errorResponse(error);
        }
    }

    @Override
    protected SqlExecuteCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SqlExecuteCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        SqlExecuteResponse response0 = (SqlExecuteResponse)response;
        List<List<Data>> rowPage = response0.getRowPage();
        Collection rowPage0 = rowPage;
        return SqlExecuteCodec.encodeResponse(response0.isUpdateCount(), response0.getQueryId(), response0.getRowMetadata(), rowPage0, response0.isRowPageLast(), response0.getUpdatedCount(), response0.getError());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:sqlService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "execute";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((SqlExecuteCodec.RequestParameters)this.parameters).sql, ((SqlExecuteCodec.RequestParameters)this.parameters).parameters, ((SqlExecuteCodec.RequestParameters)this.parameters).timeoutMillis, ((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize};
    }

    @Override
    public Permission getRequiredPermission() {
        return new SqlPermission();
    }
}

