/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import java.util.List;

public final class SqlExecuteResponse {
    private final boolean isUpdateCount;
    private final QueryId queryId;
    private final List<SqlColumnMetadata> rowMetadata;
    private final List<List<Data>> rowPage;
    private final boolean rowPageLast;
    private final SqlError error;
    private final long updatedCount;

    private SqlExecuteResponse(boolean isUpdateCount, QueryId queryId, List<SqlColumnMetadata> rowMetadata, List<List<Data>> rowPage, boolean rowPageLast, long updatedCount, SqlError error) {
        this.isUpdateCount = isUpdateCount;
        this.queryId = queryId;
        this.rowMetadata = rowMetadata;
        this.rowPage = rowPage;
        this.rowPageLast = rowPageLast;
        this.updatedCount = updatedCount;
        this.error = error;
    }

    public static SqlExecuteResponse rowsResponse(QueryId queryId, List<SqlColumnMetadata> rowMetadata, List<List<Data>> rowPage, boolean rowPageLast) {
        return new SqlExecuteResponse(false, queryId, rowMetadata, rowPage, rowPageLast, 0L, null);
    }

    public static SqlExecuteResponse errorResponse(SqlError error) {
        return new SqlExecuteResponse(false, null, null, null, true, 0L, error);
    }

    public static SqlExecuteResponse updateCountResponse(long updatedCount) {
        return new SqlExecuteResponse(true, null, null, null, true, updatedCount, null);
    }

    public boolean isUpdateCount() {
        return this.isUpdateCount;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public List<SqlColumnMetadata> getRowMetadata() {
        return this.rowMetadata;
    }

    public List<List<Data>> getRowPage() {
        return this.rowPage;
    }

    public boolean isRowPageLast() {
        return this.rowPageLast;
    }

    public SqlError getError() {
        return this.error;
    }

    public long getUpdatedCount() {
        return this.updatedCount;
    }
}

