/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.root;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.exec.root.RootResultConsumer;
import com.hazelcast.sql.impl.exec.root.ScheduleCallback;
import com.hazelcast.sql.impl.row.Row;
import java.util.List;
import java.util.NoSuchElementException;

public class BlockingRootResultConsumer
implements RootResultConsumer {
    private final Object mux = new Object();
    private final InternalIterator iterator = new InternalIterator();
    private volatile ScheduleCallback scheduleCallback;
    private List<Row> currentBatch;
    private boolean done;
    private QueryException doneError;

    @Override
    public void setup(ScheduleCallback scheduleCallback) {
        this.scheduleCallback = scheduleCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean consume(List<Row> batch, boolean last) {
        Object object = this.mux;
        synchronized (object) {
            if (this.done) {
                return false;
            }
            if (this.currentBatch == null) {
                if (!batch.isEmpty()) {
                    this.currentBatch = batch;
                }
                if (last) {
                    this.done = true;
                }
                this.mux.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(QueryException error) {
        Object object = this.mux;
        synchronized (object) {
            if (!this.done) {
                this.done = true;
                this.doneError = error;
                this.mux.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Row> awaitNextBatch() {
        Object object = this.mux;
        synchronized (object) {
            while (true) {
                if (this.currentBatch != null) {
                    List<Row> res = this.currentBatch;
                    this.currentBatch = null;
                    return res;
                }
                if (this.done) {
                    if (this.doneError != null) {
                        throw this.doneError;
                    }
                    return null;
                }
                try {
                    this.mux.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw QueryException.error("Thread was interrupted while waiting for more results.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNextBatch() {
        Object object = this.mux;
        synchronized (object) {
            if (this.done) {
                return;
            }
        }
        assert (this.scheduleCallback != null);
        this.scheduleCallback.run();
    }

    @Override
    public ResultIterator<Row> iterator() {
        return this.iterator;
    }

    private class InternalIterator
    implements ResultIterator<Row> {
        private List<Row> batch;
        private int position;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.batch == null) {
                this.batch = BlockingRootResultConsumer.this.awaitNextBatch();
                if (this.batch == null) {
                    assert (BlockingRootResultConsumer.this.done);
                    return false;
                }
            }
            return true;
        }

        @Override
        public ResultIterator.HasNextImmediatelyResult hasNextImmediately() {
            return this.hasNext() ? ResultIterator.HasNextImmediatelyResult.YES : ResultIterator.HasNextImmediatelyResult.DONE;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.batch != null);
            Row res = this.batch.get(this.position++);
            if (this.position == this.batch.size()) {
                this.batch = null;
                this.position = 0;
                BlockingRootResultConsumer.this.requestNextBatch();
            }
            return res;
        }
    }
}

