/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.MapScanExec;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.MapIndexScanExecIterator;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class MapIndexScanExec
extends MapScanExec {
    private final String indexName;
    private final IndexFilter indexFilter;
    private final List<QueryDataType> converterTypes;
    private final int componentCount;

    public MapIndexScanExec(int id, MapContainer map, PartitionIdSet parts, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, Expression<Boolean> filter, InternalSerializationService serializationService, String indexName, int componentCount, IndexFilter indexFilter, List<QueryDataType> converterTypes) {
        super(id, map, parts, keyDescriptor, valueDescriptor, fieldPaths, fieldTypes, projects, filter, serializationService);
        this.indexName = indexName;
        this.componentCount = componentCount;
        this.indexFilter = indexFilter;
        this.converterTypes = converterTypes;
    }

    @Override
    protected KeyValueIterator createIterator() {
        return new MapIndexScanExecIterator(this.map, this.indexName, this.componentCount, this.indexFilter, this.converterTypes, this.partitions, this.ctx);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapName=" + this.mapName + ", fieldPaths=" + this.fieldPaths + ", projects=" + this.projects + "indexName=" + this.indexName + ", indexFilter=" + this.indexFilter + ", remainderFilter=" + this.filter + ", partitionCount=" + this.partitions.size() + '}';
    }
}

