/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map.sample;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.sample.MapSampleMetadata;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public final class MapSampleMetadataResolver {
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_GET_FACTORY_ID = "getFactoryId";
    private static final String METHOD_GET_CLASS_ID = "getClassId";

    private MapSampleMetadataResolver() {
    }

    public static MapSampleMetadata resolve(InternalSerializationService ss, JetMapMetadataResolver jetMapMetadataResolver, Object target, boolean key) {
        try {
            if (target instanceof Portable) {
                target = ss.toData(target);
            }
            if (target instanceof Data) {
                Data data = (Data)target;
                if (data.isPortable()) {
                    return MapSampleMetadataResolver.resolvePortable(ss.getPortableContext().lookupClassDefinition(data), key, jetMapMetadataResolver);
                }
                if (data.isJson()) {
                    throw new UnsupportedOperationException("JSON objects are not supported.");
                }
                return MapSampleMetadataResolver.resolveClass(ss.toObject(data).getClass(), key, jetMapMetadataResolver);
            }
            return MapSampleMetadataResolver.resolveClass(target.getClass(), key, jetMapMetadataResolver);
        }
        catch (Exception e) {
            throw QueryException.error("Failed to resolve " + (key ? "key" : "value") + " metadata: " + e.getMessage(), e);
        }
    }

    private static MapSampleMetadata resolvePortable(ClassDefinition clazz, boolean isKey, JetMapMetadataResolver jetMapMetadataResolver) {
        TreeMap<String, MapTableField> fields = new TreeMap<String, MapTableField>();
        for (String name : clazz.getFieldNames()) {
            FieldType portableType = clazz.getFieldType(name);
            QueryDataType type = MapSampleMetadataResolver.resolvePortableType(portableType);
            fields.putIfAbsent(name, new MapTableField(name, type, false, new QueryPath(name, isKey)));
        }
        String topName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        QueryPath topPath = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        fields.put(topName, new MapTableField(topName, QueryDataType.OBJECT, !fields.isEmpty(), topPath));
        return new MapSampleMetadata(GenericQueryTargetDescriptor.DEFAULT, jetMapMetadataResolver.resolvePortable(clazz, isKey), new LinkedHashMap<String, TableField>(fields));
    }

    private static QueryDataType resolvePortableType(FieldType portableType) {
        switch (portableType) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case BYTE: {
                return QueryDataType.TINYINT;
            }
            case SHORT: {
                return QueryDataType.SMALLINT;
            }
            case CHAR: {
                return QueryDataType.VARCHAR_CHARACTER;
            }
            case UTF: {
                return QueryDataType.VARCHAR;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
        }
        return QueryDataType.OBJECT;
    }

    private static MapSampleMetadata resolveClass(Class<?> clazz, boolean isKey, JetMapMetadataResolver jetMapMetadataResolver) {
        TreeMap<String, MapTableField> fields = new TreeMap<String, MapTableField>();
        QueryDataType topType = QueryDataTypeUtils.resolveTypeForClass(clazz);
        if (topType == QueryDataType.OBJECT) {
            for (Method method : clazz.getMethods()) {
                String methodName = MapSampleMetadataResolver.extractAttributeNameFromMethod(clazz, method);
                if (methodName == null) continue;
                QueryDataType methodType = QueryDataTypeUtils.resolveTypeForClass(method.getReturnType());
                fields.putIfAbsent(methodName, new MapTableField(methodName, methodType, false, new QueryPath(methodName, isKey)));
            }
            for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    if (!Modifier.isPublic(field.getModifiers())) continue;
                    String fieldName = field.getName();
                    QueryDataType fieldType = QueryDataTypeUtils.resolveTypeForClass(field.getType());
                    fields.putIfAbsent(fieldName, new MapTableField(fieldName, fieldType, false, new QueryPath(fieldName, isKey)));
                }
            }
        }
        String topName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        QueryPath topPath = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        fields.put(topName, new MapTableField(topName, topType, !fields.isEmpty(), topPath));
        return new MapSampleMetadata(GenericQueryTargetDescriptor.DEFAULT, jetMapMetadataResolver.resolveClass(clazz, isKey), new LinkedHashMap<String, TableField>(fields));
    }

    private static String extractAttributeNameFromMethod(Class<?> clazz, Method method) {
        String fieldNameWithWrongCase;
        if (MapSampleMetadataResolver.skipMethod(clazz, method)) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.startsWith(METHOD_PREFIX_GET) && methodName.length() > METHOD_PREFIX_GET.length()) {
            fieldNameWithWrongCase = methodName.substring(METHOD_PREFIX_GET.length());
        } else if (methodName.startsWith(METHOD_PREFIX_IS) && methodName.length() > METHOD_PREFIX_IS.length()) {
            if (method.getReturnType() != Boolean.TYPE) {
                return null;
            }
            fieldNameWithWrongCase = methodName.substring(METHOD_PREFIX_IS.length());
        } else {
            return null;
        }
        return Character.toLowerCase(fieldNameWithWrongCase.charAt(0)) + fieldNameWithWrongCase.substring(1);
    }

    private static boolean skipMethod(Class<?> clazz, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return true;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return true;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return true;
        }
        if (method.getParameterCount() != 0) {
            return true;
        }
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        String methodName = method.getName();
        return !(!methodName.equals(METHOD_GET_FACTORY_ID) && !methodName.equals(METHOD_GET_CLASS_ID) || !IdentifiedDataSerializable.class.isAssignableFrom(clazz) && !Portable.class.isAssignableFrom(clazz));
    }
}

