/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.state.QueryClientState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class QueryClientStateRegistry {
    private final ConcurrentHashMap<QueryId, QueryClientState> clientCursors = new ConcurrentHashMap();

    public SqlPage registerAndFetch(UUID clientId, AbstractSqlResult result, int cursorBufferSize, InternalSerializationService serializationService) {
        QueryClientState clientCursor = new QueryClientState(clientId, result);
        SqlPage page = this.fetchInternal(clientCursor, cursorBufferSize, serializationService);
        if (!page.isLast()) {
            this.clientCursors.put(result.getQueryId(), clientCursor);
        }
        return page;
    }

    public SqlPage fetch(UUID clientId, QueryId queryId, int cursorBufferSize, InternalSerializationService serializationService) {
        QueryClientState clientCursor = this.getClientCursor(clientId, queryId);
        if (clientCursor == null) {
            throw QueryException.error("Query cursor is not found (closed?): " + queryId);
        }
        SqlPage page = this.fetchInternal(clientCursor, cursorBufferSize, serializationService);
        if (page.isLast()) {
            this.deleteClientCursor(clientCursor);
        }
        return page;
    }

    private SqlPage fetchInternal(QueryClientState clientCursor, int cursorBufferSize, InternalSerializationService serializationService) {
        ArrayList<List<Data>> page;
        ResultIterator<SqlRow> iterator = clientCursor.getIterator();
        boolean last = QueryClientStateRegistry.fetchPage(iterator, page = new ArrayList<List<Data>>(cursorBufferSize), cursorBufferSize, serializationService);
        if (last) {
            this.deleteClientCursor(clientCursor);
        }
        return new SqlPage(page, last);
    }

    private static boolean fetchPage(ResultIterator<SqlRow> iterator, List<List<Data>> page, int cursorBufferSize, InternalSerializationService serializationService) {
        ResultIterator.HasNextImmediatelyResult hasNextResult;
        assert (cursorBufferSize > 0);
        if (!iterator.hasNext()) {
            return true;
        }
        do {
            SqlRow row = (SqlRow)iterator.next();
            List<Data> convertedRow = QueryClientStateRegistry.convertRow(row, serializationService);
            page.add(convertedRow);
        } while ((hasNextResult = iterator.hasNextImmediately()) == ResultIterator.HasNextImmediatelyResult.YES && page.size() < cursorBufferSize);
        return hasNextResult == ResultIterator.HasNextImmediatelyResult.DONE;
    }

    private static List<Data> convertRow(SqlRow row, InternalSerializationService serializationService) {
        int columnCount = row.getMetadata().getColumnCount();
        ArrayList<Data> values = new ArrayList<Data>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            values.add((Data)serializationService.toData(row.getObject(i)));
        }
        return values;
    }

    public void close(UUID clientId, QueryId queryId) {
        QueryClientState clientCursor = this.getClientCursor(clientId, queryId);
        if (clientCursor != null) {
            clientCursor.getSqlResult().close();
            this.deleteClientCursor(clientCursor);
        }
    }

    public void reset() {
        this.clientCursors.clear();
    }

    public void update(Set<UUID> activeClientIds) {
        ArrayList<QueryClientState> victims = new ArrayList<QueryClientState>();
        for (QueryClientState clientCursor : this.clientCursors.values()) {
            if (activeClientIds.contains(clientCursor.getClientId())) continue;
            victims.add(clientCursor);
        }
        for (QueryClientState victim : victims) {
            QueryException error = QueryException.clientMemberConnection(victim.getClientId());
            victim.getSqlResult().closeOnError(error);
            this.deleteClientCursor(victim);
        }
    }

    private QueryClientState getClientCursor(UUID clientId, QueryId queryId) {
        QueryClientState cursor = this.clientCursors.get(queryId);
        if (cursor == null || !cursor.getClientId().equals(clientId)) {
            return null;
        }
        return cursor;
    }

    private void deleteClientCursor(QueryClientState cursor) {
        this.clientCursors.remove(cursor.getQueryId());
    }

    public int getCursorCount() {
        return this.clientCursors.size();
    }
}

