/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.ClockProvider;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import com.hazelcast.sql.impl.state.QueryDistributedState;
import com.hazelcast.sql.impl.state.QueryInitiatorState;
import com.hazelcast.sql.impl.state.QueryStateCallback;
import com.hazelcast.sql.impl.state.QueryStateCompletionCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public final class QueryState
implements QueryStateCallback {
    private final QueryId queryId;
    private final AtomicBoolean completionGuard = new AtomicBoolean();
    private final QueryStateCompletionCallback completionCallback;
    private final QueryInitiatorState initiatorState;
    private final QueryDistributedState distributedState = new QueryDistributedState();
    private final ClockProvider clockProvider;
    private final long startTime;
    private final UUID localMemberId;
    private volatile QueryException completionError;
    private volatile long checkTime;

    private QueryState(QueryId queryId, UUID localMemberId, QueryStateCompletionCallback completionCallback, boolean initiator, long initiatorTimeout, Plan initiatorPlan, CachedPlanInvalidationCallback initiatorPlanInvalidationCallback, SqlRowMetadata initiatorRowMetadata, QueryResultProducer initiatorRowSource, ClockProvider clockProvider) {
        this.queryId = queryId;
        this.completionCallback = completionCallback;
        this.localMemberId = localMemberId;
        this.initiatorState = initiator ? new QueryInitiatorState(queryId, initiatorPlan, initiatorPlanInvalidationCallback, initiatorRowMetadata, initiatorRowSource, initiatorTimeout) : null;
        this.clockProvider = clockProvider;
        this.checkTime = this.startTime = clockProvider.currentTimeMillis();
    }

    public static QueryState createInitiatorState(QueryId queryId, UUID localMemberId, QueryStateCompletionCallback completionCallback, long initiatorTimeout, Plan initiatorPlan, CachedPlanInvalidationCallback initiatorPlanInvalidationCallback, SqlRowMetadata initiatorRowMetadata, QueryResultProducer initiatorResultProducer, ClockProvider clockProvider) {
        return new QueryState(queryId, localMemberId, completionCallback, true, initiatorTimeout, initiatorPlan, initiatorPlanInvalidationCallback, initiatorRowMetadata, initiatorResultProducer, clockProvider);
    }

    public static QueryState createDistributedState(QueryId queryId, UUID localMemberId, QueryStateCompletionCallback completionCallback, ClockProvider clockProvider) {
        return new QueryState(queryId, localMemberId, completionCallback, false, -1L, null, null, null, null, clockProvider);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public UUID getLocalMemberId() {
        return this.localMemberId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isInitiator() {
        return this.initiatorState != null;
    }

    public QueryInitiatorState getInitiatorState() {
        return this.initiatorState;
    }

    public QueryDistributedState getDistributedState() {
        return this.distributedState;
    }

    @Override
    public void onFragmentFinished() {
        if (this.distributedState.onFragmentFinished()) {
            assert (this.completionCallback != null);
            if (!this.completionGuard.compareAndSet(false, true)) {
                return;
            }
            this.completionCallback.onCompleted(this.queryId);
        }
    }

    @Override
    public void cancel(Exception error) {
        Collection<UUID> memberIds;
        CachedPlanInvalidationCallback planInvalidationCallback;
        if (!this.completionGuard.compareAndSet(false, true)) {
            return;
        }
        QueryException error0 = this.prepareCancelError(error);
        if (this.isInitiator() && error0.isInvalidatePlan() && (planInvalidationCallback = this.initiatorState.getPlanInvalidationCallback()) != null) {
            planInvalidationCallback.invalidate(this.initiatorState.getPlan());
        }
        if (this.isInitiator()) {
            memberIds = new HashSet<UUID>(this.getParticipants());
            memberIds.remove(this.localMemberId);
        } else {
            boolean isLocal = error0.getOriginatingMemberId().equals(this.localMemberId);
            memberIds = isLocal ? Collections.singletonList(this.queryId.getMemberId()) : Collections.emptyList();
        }
        assert (this.completionCallback != null);
        this.completionCallback.onError(this.queryId, error0.getCode(), error0.getMessage(), error0.getOriginatingMemberId(), memberIds);
        this.completionError = error0;
        if (this.isInitiator()) {
            this.initiatorState.getResultProducer().onError(error0);
        }
    }

    private QueryException prepareCancelError(Exception error) {
        if (error instanceof QueryException) {
            QueryException error0 = (QueryException)error;
            if (error0.getOriginatingMemberId() == null) {
                boolean invalidatePlan = error0.isInvalidatePlan();
                error0 = QueryException.error(error0.getCode(), error0.getMessage(), error0.getCause(), this.localMemberId);
                if (invalidatePlan) {
                    error0 = error0.withInvalidate();
                }
            }
            return error0;
        }
        return QueryException.error(-1, error.getMessage(), error, this.localMemberId);
    }

    public boolean tryCancelOnMemberLeave(Collection<UUID> memberIds) {
        Set<UUID> missingMemberIds = null;
        if (this.isInitiator()) {
            if (!memberIds.containsAll(this.getParticipants())) {
                missingMemberIds = new HashSet<UUID>(this.getParticipants());
                missingMemberIds.removeAll(memberIds);
            }
        } else {
            UUID initiatorMemberId = this.queryId.getMemberId();
            if (!memberIds.contains(initiatorMemberId)) {
                missingMemberIds = Collections.singleton(initiatorMemberId);
            }
        }
        if (missingMemberIds == null) {
            return false;
        }
        assert (!missingMemberIds.isEmpty());
        this.cancel(QueryException.memberConnection(missingMemberIds));
        return true;
    }

    public boolean tryCancelOnTimeout() {
        if (!this.isInitiator()) {
            return false;
        }
        long timeout = this.initiatorState.getTimeout();
        if (timeout > 0L && this.clockProvider.currentTimeMillis() - this.startTime > timeout) {
            this.cancel(QueryException.timeout(timeout));
            return true;
        }
        return false;
    }

    public boolean requestQueryCheck(long checkFrequency) {
        if (this.isInitiator()) {
            return false;
        }
        if (this.distributedState.isStarted()) {
            return false;
        }
        long currentTime = this.clockProvider.currentTimeMillis();
        if (currentTime - this.checkTime < checkFrequency) {
            return false;
        }
        this.checkTime = currentTime;
        return true;
    }

    @Override
    public void checkCancelled() {
        QueryException completionError0 = this.completionError;
        if (completionError0 != null) {
            throw completionError0;
        }
    }

    private Collection<UUID> getParticipants() {
        return this.initiatorState.getPlan().getMemberIds();
    }
}

