/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.ClockProvider;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import com.hazelcast.sql.impl.state.QueryState;
import com.hazelcast.sql.impl.state.QueryStateCompletionCallback;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class QueryStateRegistry {
    private final ConcurrentHashMap<QueryId, QueryState> states = new ConcurrentHashMap();
    private final ClockProvider clockProvider;

    public QueryStateRegistry(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
    }

    public QueryState onInitiatorQueryStarted(UUID localMemberId, long initiatorTimeout, Plan initiatorPlan, CachedPlanInvalidationCallback initiatorPlanInvalidationCallback, SqlRowMetadata initiatorRowMetadata, QueryResultProducer initiatorResultProducer, QueryStateCompletionCallback completionCallback) {
        QueryId queryId = QueryId.create(localMemberId);
        QueryState state = QueryState.createInitiatorState(queryId, localMemberId, completionCallback, initiatorTimeout, initiatorPlan, initiatorPlanInvalidationCallback, initiatorRowMetadata, initiatorResultProducer, this.clockProvider);
        this.states.put(queryId, state);
        return state;
    }

    public QueryState onDistributedQueryStarted(UUID localMemberId, QueryId queryId, QueryStateCompletionCallback completionCallback) {
        QueryState oldState;
        UUID initiatorMemberId = queryId.getMemberId();
        boolean local = localMemberId.equals(initiatorMemberId);
        if (local) {
            return this.states.get(queryId);
        }
        QueryState state = this.states.get(queryId);
        if (state == null && (oldState = this.states.putIfAbsent(queryId, state = QueryState.createDistributedState(queryId, localMemberId, completionCallback, this.clockProvider))) != null) {
            state = oldState;
        }
        return state;
    }

    public void onQueryCompleted(QueryId queryId) {
        this.states.remove(queryId);
    }

    public void reset() {
        this.states.clear();
    }

    public QueryState getState(QueryId queryId) {
        return this.states.get(queryId);
    }

    public Collection<QueryState> getStates() {
        return this.states.values();
    }
}

