/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CacheSimpleConfig
implements IdentifiedDataSerializable,
NamedConfig {
    public static final int MIN_BACKUP_COUNT = 0;
    public static final int MAX_BACKUP_COUNT = 6;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private String name;
    private String keyType;
    private String valueType;
    private boolean statisticsEnabled;
    private boolean managementEnabled;
    private boolean readThrough;
    private boolean writeThrough;
    private String cacheLoaderFactory;
    private String cacheWriterFactory;
    private String cacheLoader;
    private String cacheWriter;
    private ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig;
    private List<CacheSimpleEntryListenerConfig> cacheEntryListeners;
    private int asyncBackupCount = 0;
    private int backupCount = 1;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private EvictionConfig evictionConfig = new EvictionConfig();
    private WanReplicationRef wanReplicationRef;
    private String splitBrainProtectionName;
    private List<CachePartitionLostListenerConfig> partitionLostListenerConfigs;
    private HotRestartConfig hotRestartConfig = new HotRestartConfig();
    private EventJournalConfig eventJournalConfig = new EventJournalConfig();
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
    private boolean disablePerEntryInvalidationEvents;

    public CacheSimpleConfig(CacheSimpleConfig cacheSimpleConfig) {
        this.name = cacheSimpleConfig.name;
        this.keyType = cacheSimpleConfig.keyType;
        this.valueType = cacheSimpleConfig.valueType;
        this.statisticsEnabled = cacheSimpleConfig.statisticsEnabled;
        this.managementEnabled = cacheSimpleConfig.managementEnabled;
        this.readThrough = cacheSimpleConfig.readThrough;
        this.writeThrough = cacheSimpleConfig.writeThrough;
        this.cacheLoaderFactory = cacheSimpleConfig.cacheLoaderFactory;
        this.cacheWriterFactory = cacheSimpleConfig.cacheWriterFactory;
        this.expiryPolicyFactoryConfig = cacheSimpleConfig.expiryPolicyFactoryConfig;
        this.cacheEntryListeners = cacheSimpleConfig.cacheEntryListeners == null ? null : new ArrayList<CacheSimpleEntryListenerConfig>(cacheSimpleConfig.cacheEntryListeners);
        this.asyncBackupCount = cacheSimpleConfig.asyncBackupCount;
        this.backupCount = cacheSimpleConfig.backupCount;
        this.inMemoryFormat = cacheSimpleConfig.inMemoryFormat;
        if (cacheSimpleConfig.evictionConfig != null) {
            this.evictionConfig = cacheSimpleConfig.evictionConfig;
        }
        this.wanReplicationRef = cacheSimpleConfig.wanReplicationRef;
        this.partitionLostListenerConfigs = cacheSimpleConfig.partitionLostListenerConfigs == null ? null : new ArrayList<CachePartitionLostListenerConfig>(cacheSimpleConfig.partitionLostListenerConfigs);
        this.splitBrainProtectionName = cacheSimpleConfig.splitBrainProtectionName;
        this.mergePolicyConfig = new MergePolicyConfig(cacheSimpleConfig.mergePolicyConfig);
        this.hotRestartConfig = new HotRestartConfig(cacheSimpleConfig.hotRestartConfig);
        this.eventJournalConfig = new EventJournalConfig(cacheSimpleConfig.eventJournalConfig);
        this.disablePerEntryInvalidationEvents = cacheSimpleConfig.disablePerEntryInvalidationEvents;
    }

    public CacheSimpleConfig(String name) {
        this.setName(name);
    }

    public CacheSimpleConfig() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CacheSimpleConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public CacheSimpleConfig setKeyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public String getValueType() {
        return this.valueType;
    }

    public CacheSimpleConfig setValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public CacheSimpleConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public CacheSimpleConfig setManagementEnabled(boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
        return this;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public CacheSimpleConfig setReadThrough(boolean readThrough) {
        this.readThrough = readThrough;
        return this;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public CacheSimpleConfig setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
        return this;
    }

    public String getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public CacheSimpleConfig setCacheLoaderFactory(String cacheLoaderFactory) {
        if (this.cacheLoader != null && cacheLoaderFactory != null) {
            throw new IllegalStateException("Cannot set cacheLoaderFactory to '" + cacheLoaderFactory + "', because cacheLoader is already set to '" + this.cacheLoader + "'.");
        }
        this.cacheLoaderFactory = cacheLoaderFactory;
        return this;
    }

    public String getCacheLoader() {
        return this.cacheLoader;
    }

    public CacheSimpleConfig setCacheLoader(String cacheLoader) {
        if (cacheLoader != null && this.cacheLoaderFactory != null) {
            throw new IllegalStateException("Cannot set cacheLoader to '" + cacheLoader + "', because cacheLoaderFactory is already set to '" + this.cacheLoaderFactory + "'.");
        }
        this.cacheLoader = cacheLoader;
        return this;
    }

    public String getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public CacheSimpleConfig setCacheWriterFactory(String cacheWriterFactory) {
        if (this.cacheWriter != null && cacheWriterFactory != null) {
            throw new IllegalStateException("Cannot set cacheWriterFactory to '" + cacheWriterFactory + "', because cacheWriter is already set to '" + this.cacheWriter + "'.");
        }
        this.cacheWriterFactory = cacheWriterFactory;
        return this;
    }

    public String getCacheWriter() {
        return this.cacheWriter;
    }

    public CacheSimpleConfig setCacheWriter(String cacheWriter) {
        if (cacheWriter != null && this.cacheWriterFactory != null) {
            throw new IllegalStateException("Cannot set cacheWriter to '" + cacheWriter + "', because cacheWriterFactory is already set to '" + this.cacheWriterFactory + "'.");
        }
        this.cacheWriter = cacheWriter;
        return this;
    }

    public ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig() {
        return this.expiryPolicyFactoryConfig;
    }

    public CacheSimpleConfig setExpiryPolicyFactoryConfig(ExpiryPolicyFactoryConfig expiryPolicyFactoryConfig) {
        this.expiryPolicyFactoryConfig = expiryPolicyFactoryConfig;
        return this;
    }

    public CacheSimpleConfig setExpiryPolicyFactory(String className) {
        this.expiryPolicyFactoryConfig = new ExpiryPolicyFactoryConfig(className);
        return this;
    }

    public CacheSimpleConfig addEntryListenerConfig(CacheSimpleEntryListenerConfig listenerConfig) {
        this.getCacheEntryListeners().add(listenerConfig);
        return this;
    }

    public List<CacheSimpleEntryListenerConfig> getCacheEntryListeners() {
        if (this.cacheEntryListeners == null) {
            this.cacheEntryListeners = new ArrayList<CacheSimpleEntryListenerConfig>();
        }
        return this.cacheEntryListeners;
    }

    public CacheSimpleConfig setCacheEntryListeners(List<CacheSimpleEntryListenerConfig> cacheEntryListeners) {
        this.cacheEntryListeners = cacheEntryListeners;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public CacheSimpleConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public CacheSimpleConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public CacheSimpleConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = Preconditions.isNotNull(inMemoryFormat, "In-Memory format cannot be null!");
        return this;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public CacheSimpleConfig setEvictionConfig(EvictionConfig evictionConfig) {
        this.evictionConfig = Preconditions.isNotNull(evictionConfig, "evictionConfig");
        return this;
    }

    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRef;
    }

    public CacheSimpleConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        this.wanReplicationRef = wanReplicationRef;
        return this;
    }

    public List<CachePartitionLostListenerConfig> getPartitionLostListenerConfigs() {
        if (this.partitionLostListenerConfigs == null) {
            this.partitionLostListenerConfigs = new ArrayList<CachePartitionLostListenerConfig>();
        }
        return this.partitionLostListenerConfigs;
    }

    public CacheSimpleConfig setPartitionLostListenerConfigs(List<CachePartitionLostListenerConfig> partitionLostListenerConfigs) {
        this.partitionLostListenerConfigs = partitionLostListenerConfigs;
        return this;
    }

    public CacheSimpleConfig addCachePartitionLostListenerConfig(CachePartitionLostListenerConfig listenerConfig) {
        this.getPartitionLostListenerConfigs().add(listenerConfig);
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public CacheSimpleConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public CacheSimpleConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null!");
        return this;
    }

    public HotRestartConfig getHotRestartConfig() {
        return this.hotRestartConfig;
    }

    public CacheSimpleConfig setHotRestartConfig(HotRestartConfig hotRestartConfig) {
        this.hotRestartConfig = hotRestartConfig;
        return this;
    }

    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    public CacheSimpleConfig setEventJournalConfig(@Nonnull EventJournalConfig eventJournalConfig) {
        this.eventJournalConfig = Preconditions.checkNotNull(eventJournalConfig, "eventJournalConfig cannot be null!");
        return this;
    }

    public boolean isDisablePerEntryInvalidationEvents() {
        return this.disablePerEntryInvalidationEvents;
    }

    public CacheSimpleConfig setDisablePerEntryInvalidationEvents(boolean disablePerEntryInvalidationEvents) {
        this.disablePerEntryInvalidationEvents = disablePerEntryInvalidationEvents;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 37;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.keyType);
        out.writeUTF(this.valueType);
        out.writeBoolean(this.statisticsEnabled);
        out.writeBoolean(this.managementEnabled);
        out.writeBoolean(this.readThrough);
        out.writeBoolean(this.writeThrough);
        out.writeBoolean(this.disablePerEntryInvalidationEvents);
        out.writeUTF(this.cacheLoaderFactory);
        out.writeUTF(this.cacheWriterFactory);
        out.writeUTF(this.cacheLoader);
        out.writeUTF(this.cacheWriter);
        out.writeObject(this.expiryPolicyFactoryConfig);
        SerializationUtil.writeNullableList(this.cacheEntryListeners, out);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.backupCount);
        out.writeUTF(this.inMemoryFormat.name());
        out.writeObject(this.evictionConfig);
        out.writeObject(this.wanReplicationRef);
        out.writeUTF(this.splitBrainProtectionName);
        SerializationUtil.writeNullableList(this.partitionLostListenerConfigs, out);
        out.writeObject(this.mergePolicyConfig);
        out.writeObject(this.hotRestartConfig);
        out.writeObject(this.eventJournalConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.keyType = in.readUTF();
        this.valueType = in.readUTF();
        this.statisticsEnabled = in.readBoolean();
        this.managementEnabled = in.readBoolean();
        this.readThrough = in.readBoolean();
        this.writeThrough = in.readBoolean();
        this.disablePerEntryInvalidationEvents = in.readBoolean();
        this.cacheLoaderFactory = in.readUTF();
        this.cacheWriterFactory = in.readUTF();
        this.cacheLoader = in.readUTF();
        this.cacheWriter = in.readUTF();
        this.expiryPolicyFactoryConfig = (ExpiryPolicyFactoryConfig)in.readObject();
        this.cacheEntryListeners = SerializationUtil.readNullableList(in);
        this.asyncBackupCount = in.readInt();
        this.backupCount = in.readInt();
        this.inMemoryFormat = InMemoryFormat.valueOf(in.readUTF());
        this.evictionConfig = (EvictionConfig)in.readObject();
        this.wanReplicationRef = (WanReplicationRef)in.readObject();
        this.splitBrainProtectionName = in.readUTF();
        this.partitionLostListenerConfigs = SerializationUtil.readNullableList(in);
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
        this.hotRestartConfig = (HotRestartConfig)in.readObject();
        this.eventJournalConfig = (EventJournalConfig)in.readObject();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheSimpleConfig)) {
            return false;
        }
        CacheSimpleConfig that = (CacheSimpleConfig)o;
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (this.managementEnabled != that.managementEnabled) {
            return false;
        }
        if (this.readThrough != that.readThrough) {
            return false;
        }
        if (this.writeThrough != that.writeThrough) {
            return false;
        }
        if (this.asyncBackupCount != that.asyncBackupCount) {
            return false;
        }
        if (this.backupCount != that.backupCount) {
            return false;
        }
        if (this.disablePerEntryInvalidationEvents != that.disablePerEntryInvalidationEvents) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Objects.equals(this.keyType, that.keyType)) {
            return false;
        }
        if (!Objects.equals(this.valueType, that.valueType)) {
            return false;
        }
        if (!Objects.equals(this.cacheLoaderFactory, that.cacheLoaderFactory)) {
            return false;
        }
        if (!Objects.equals(this.cacheWriterFactory, that.cacheWriterFactory)) {
            return false;
        }
        if (!Objects.equals(this.cacheLoader, that.cacheLoader)) {
            return false;
        }
        if (!Objects.equals(this.cacheWriter, that.cacheWriter)) {
            return false;
        }
        if (!Objects.equals(this.expiryPolicyFactoryConfig, that.expiryPolicyFactoryConfig)) {
            return false;
        }
        if (!Objects.equals(this.cacheEntryListeners, that.cacheEntryListeners)) {
            return false;
        }
        if (this.inMemoryFormat != that.inMemoryFormat) {
            return false;
        }
        if (!Objects.equals(this.evictionConfig, that.evictionConfig)) {
            return false;
        }
        if (!Objects.equals(this.wanReplicationRef, that.wanReplicationRef)) {
            return false;
        }
        if (!Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName)) {
            return false;
        }
        if (!Objects.equals(this.partitionLostListenerConfigs, that.partitionLostListenerConfigs)) {
            return false;
        }
        if (!Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig)) {
            return false;
        }
        if (!Objects.equals(this.eventJournalConfig, that.eventJournalConfig)) {
            return false;
        }
        return Objects.equals(this.hotRestartConfig, that.hotRestartConfig);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        result = 31 * result + (this.managementEnabled ? 1 : 0);
        result = 31 * result + (this.readThrough ? 1 : 0);
        result = 31 * result + (this.writeThrough ? 1 : 0);
        result = 31 * result + (this.cacheLoaderFactory != null ? this.cacheLoaderFactory.hashCode() : 0);
        result = 31 * result + (this.cacheWriterFactory != null ? this.cacheWriterFactory.hashCode() : 0);
        result = 31 * result + (this.cacheLoader != null ? this.cacheLoader.hashCode() : 0);
        result = 31 * result + (this.cacheWriter != null ? this.cacheWriter.hashCode() : 0);
        result = 31 * result + (this.expiryPolicyFactoryConfig != null ? this.expiryPolicyFactoryConfig.hashCode() : 0);
        result = 31 * result + (this.cacheEntryListeners != null ? this.cacheEntryListeners.hashCode() : 0);
        result = 31 * result + this.asyncBackupCount;
        result = 31 * result + this.backupCount;
        result = 31 * result + (this.inMemoryFormat != null ? this.inMemoryFormat.hashCode() : 0);
        result = 31 * result + (this.evictionConfig != null ? this.evictionConfig.hashCode() : 0);
        result = 31 * result + (this.wanReplicationRef != null ? this.wanReplicationRef.hashCode() : 0);
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.partitionLostListenerConfigs != null ? this.partitionLostListenerConfigs.hashCode() : 0);
        result = 31 * result + (this.mergePolicyConfig != null ? this.mergePolicyConfig.hashCode() : 0);
        result = 31 * result + (this.hotRestartConfig != null ? this.hotRestartConfig.hashCode() : 0);
        result = 31 * result + (this.eventJournalConfig != null ? this.eventJournalConfig.hashCode() : 0);
        result = 31 * result + (this.disablePerEntryInvalidationEvents ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CacheSimpleConfig{name='" + this.name + '\'' + ", asyncBackupCount=" + this.asyncBackupCount + ", backupCount=" + this.backupCount + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", keyType=" + this.keyType + ", valueType=" + this.valueType + ", statisticsEnabled=" + this.statisticsEnabled + ", managementEnabled=" + this.managementEnabled + ", readThrough=" + this.readThrough + ", writeThrough=" + this.writeThrough + ", cacheLoaderFactory='" + this.cacheLoaderFactory + '\'' + ", cacheWriterFactory='" + this.cacheWriterFactory + '\'' + ", cacheLoader='" + this.cacheLoader + '\'' + ", cacheWriter='" + this.cacheWriter + '\'' + ", expiryPolicyFactoryConfig=" + this.expiryPolicyFactoryConfig + ", cacheEntryListeners=" + this.cacheEntryListeners + ", evictionConfig=" + this.evictionConfig + ", wanReplicationRef=" + this.wanReplicationRef + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", partitionLostListenerConfigs=" + this.partitionLostListenerConfigs + ", mergePolicyConfig=" + this.mergePolicyConfig + ", hotRestartConfig=" + this.hotRestartConfig + ", eventJournal=" + this.eventJournalConfig + '}';
    }

    public static class ExpiryPolicyFactoryConfig
    implements IdentifiedDataSerializable {
        private String className;
        private TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig;

        public ExpiryPolicyFactoryConfig() {
        }

        public ExpiryPolicyFactoryConfig(String className) {
            this.className = className;
            this.timedExpiryPolicyFactoryConfig = null;
        }

        public ExpiryPolicyFactoryConfig(TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig) {
            this.className = null;
            this.timedExpiryPolicyFactoryConfig = timedExpiryPolicyFactoryConfig;
        }

        public String getClassName() {
            return this.className;
        }

        public TimedExpiryPolicyFactoryConfig getTimedExpiryPolicyFactoryConfig() {
            return this.timedExpiryPolicyFactoryConfig;
        }

        @Override
        public int getFactoryId() {
            return ConfigDataSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 38;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.className);
            out.writeObject(this.timedExpiryPolicyFactoryConfig);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.className = in.readUTF();
            this.timedExpiryPolicyFactoryConfig = (TimedExpiryPolicyFactoryConfig)in.readObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiryPolicyFactoryConfig that = (ExpiryPolicyFactoryConfig)o;
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return this.timedExpiryPolicyFactoryConfig != null ? this.timedExpiryPolicyFactoryConfig.equals(that.timedExpiryPolicyFactoryConfig) : that.timedExpiryPolicyFactoryConfig == null;
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.timedExpiryPolicyFactoryConfig != null ? this.timedExpiryPolicyFactoryConfig.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ExpiryPolicyFactoryConfig{className='" + this.className + '\'' + ", timedExpiryPolicyFactoryConfig=" + this.timedExpiryPolicyFactoryConfig + '}';
        }

        public static class DurationConfig
        implements IdentifiedDataSerializable {
            private long durationAmount;
            private TimeUnit timeUnit;

            public DurationConfig() {
            }

            public DurationConfig(long durationAmount, TimeUnit timeUnit) {
                this.durationAmount = durationAmount;
                this.timeUnit = timeUnit;
            }

            public long getDurationAmount() {
                return this.durationAmount;
            }

            public TimeUnit getTimeUnit() {
                return this.timeUnit;
            }

            @Override
            public int getFactoryId() {
                return ConfigDataSerializerHook.F_ID;
            }

            @Override
            public int getClassId() {
                return 40;
            }

            @Override
            public void writeData(ObjectDataOutput out) throws IOException {
                out.writeLong(this.durationAmount);
                out.writeUTF(this.timeUnit.name());
            }

            @Override
            public void readData(ObjectDataInput in) throws IOException {
                this.durationAmount = in.readLong();
                this.timeUnit = TimeUnit.valueOf(in.readUTF());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DurationConfig that = (DurationConfig)o;
                if (this.durationAmount != that.durationAmount) {
                    return false;
                }
                return this.timeUnit == that.timeUnit;
            }

            public int hashCode() {
                int result = (int)(this.durationAmount ^ this.durationAmount >>> 32);
                result = 31 * result + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "DurationConfig{durationAmount=" + this.durationAmount + ", timeUnit" + (Object)((Object)this.timeUnit) + '}';
            }
        }

        public static class TimedExpiryPolicyFactoryConfig
        implements IdentifiedDataSerializable {
            private ExpiryPolicyType expiryPolicyType;
            private DurationConfig durationConfig;

            public TimedExpiryPolicyFactoryConfig() {
            }

            public TimedExpiryPolicyFactoryConfig(ExpiryPolicyType expiryPolicyType, DurationConfig durationConfig) {
                this.expiryPolicyType = expiryPolicyType;
                this.durationConfig = durationConfig;
            }

            public ExpiryPolicyType getExpiryPolicyType() {
                return this.expiryPolicyType;
            }

            public DurationConfig getDurationConfig() {
                return this.durationConfig;
            }

            @Override
            public int getFactoryId() {
                return ConfigDataSerializerHook.F_ID;
            }

            @Override
            public int getClassId() {
                return 39;
            }

            @Override
            public void writeData(ObjectDataOutput out) throws IOException {
                out.writeUTF(this.expiryPolicyType.name());
                out.writeObject(this.durationConfig);
            }

            @Override
            public void readData(ObjectDataInput in) throws IOException {
                this.expiryPolicyType = ExpiryPolicyType.valueOf(in.readUTF());
                this.durationConfig = (DurationConfig)in.readObject();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TimedExpiryPolicyFactoryConfig that = (TimedExpiryPolicyFactoryConfig)o;
                if (this.expiryPolicyType != that.expiryPolicyType) {
                    return false;
                }
                return Objects.equals(this.durationConfig, that.durationConfig);
            }

            public int hashCode() {
                int result = this.expiryPolicyType != null ? this.expiryPolicyType.hashCode() : 0;
                result = 31 * result + (this.durationConfig != null ? this.durationConfig.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "TimedExpiryPolicyFactoryConfig{expiryPolicyType=" + (Object)((Object)this.expiryPolicyType) + ", durationConfig=" + this.durationConfig + '}';
            }

            public static enum ExpiryPolicyType {
                CREATED(0),
                MODIFIED(1),
                ACCESSED(2),
                TOUCHED(3),
                ETERNAL(4);

                private static final int MIN_ID;
                private static final int MAX_ID;
                private static final ExpiryPolicyType[] CACHED_VALUES;
                private int id;

                private ExpiryPolicyType(int id) {
                    this.id = id;
                }

                public int getId() {
                    return this.id;
                }

                public static ExpiryPolicyType getById(int id) {
                    if (MIN_ID <= id && id <= MAX_ID) {
                        return CACHED_VALUES[id];
                    }
                    return null;
                }

                static {
                    MIN_ID = ExpiryPolicyType.CREATED.id;
                    MAX_ID = ExpiryPolicyType.ETERNAL.id;
                    CACHED_VALUES = ExpiryPolicyType.values();
                }
            }
        }
    }
}

